/*
 * @version   : 1.17.0 - A Bridge.NET implementation of Newtonsoft.Json
 * @author    : Object.NET, Inc. http://www.bridge.net/
 * @copyright : Copyright (c) 2008-2019, Object.NET, Inc. (http://www.object.net/). All rights reserved.
 * @license   : See license.txt and https://github.com/bridgedotnet/Bridge.NET/blob/master/LICENSE.
 */Bridge.assembly("Newtonsoft.Json",function($asm,globals){"use strict";Bridge.define("Newtonsoft.Json.DefaultValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1,Populate:2,IgnoreAndPopulate:3}},$flags:!0}),Bridge.define("Newtonsoft.Json.Formatting",{$kind:"enum",statics:{fields:{None:0,Indented:1}}}),Bridge.define("Newtonsoft.Json.JsonConstructorAttribute",{inherits:[System.Attribute]}),Bridge.define("Newtonsoft.Json.JsonException",{inherits:[System.Exception],ctors:{ctor:function(){this.$initialize(),System.Exception.ctor.call(this)},$ctor1:function(n){this.$initialize(),System.Exception.ctor.call(this,n)},$ctor2:function(n,t){this.$initialize(),System.Exception.ctor.call(this,n,t)}}}),Bridge.define("Newtonsoft.Json.JsonIgnoreAttribute",{inherits:[System.Attribute]}),Bridge.define("Newtonsoft.Json.JsonPropertyAttribute",{inherits:[System.Attribute],fields:{_nullValueHandling:null,_defaultValueHandling:null,_objectCreationHandling:null,_typeNameHandling:null,_required:null,_order:null},props:{NullValueHandling:{get:function(){var n;return n=this._nullValueHandling,n??0},set:function(n){this._nullValueHandling=n}},DefaultValueHandling:{get:function(){var n;return n=this._defaultValueHandling,n??0},set:function(n){this._defaultValueHandling=n}},ObjectCreationHandling:{get:function(){var n;return n=this._objectCreationHandling,n??0},set:function(n){this._objectCreationHandling=n}},TypeNameHandling:{get:function(){var n;return n=this._typeNameHandling,n??0},set:function(n){this._typeNameHandling=n}},Required:{get:function(){var n;return n=this._required,n??Newtonsoft.Json.Required.Default},set:function(n){this._required=n}},Order:{get:function(){var n;return n=this._order,n??Bridge.getDefaultValue(System.Int32)},set:function(n){this._order=n}},PropertyName:null},ctors:{ctor:function(){this.$initialize(),System.Attribute.ctor.call(this)},$ctor1:function(n){this.$initialize(),System.Attribute.ctor.call(this),this.PropertyName=n}}}),Bridge.define("Newtonsoft.Json.JsonSerializerSettings",{statics:{fields:{DefaultNullValueHandling:0,DefaultTypeNameHandling:0},ctors:{init:function(){this.DefaultNullValueHandling=Newtonsoft.Json.NullValueHandling.Include,this.DefaultTypeNameHandling=Newtonsoft.Json.TypeNameHandling.None}}},fields:{_defaultValueHandling:null,_typeNameHandling:null,_nullValueHandling:null,_objectCreationHandling:null},props:{NullValueHandling:{get:function(){var n;return n=this._nullValueHandling,n??Newtonsoft.Json.JsonSerializerSettings.DefaultNullValueHandling},set:function(n){this._nullValueHandling=n}},ObjectCreationHandling:{get:function(){var n;return n=this._objectCreationHandling,n??0},set:function(n){this._objectCreationHandling=n}},DefaultValueHandling:{get:function(){var n;return n=this._defaultValueHandling,n??0},set:function(n){this._defaultValueHandling=n}},TypeNameHandling:{get:function(){var n;return n=this._typeNameHandling,n??Newtonsoft.Json.JsonSerializerSettings.DefaultTypeNameHandling},set:function(n){this._typeNameHandling=n}},ContractResolver:null,SerializationBinder:null}}),Bridge.define("Newtonsoft.Json.NullValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1}}}),Bridge.define("Newtonsoft.Json.ObjectCreationHandling",{$kind:"enum",statics:{fields:{Auto:0,Reuse:1,Replace:2}}}),Bridge.define("Newtonsoft.Json.Required",{$kind:"enum",statics:{fields:{Default:0,AllowNull:1,Always:2,DisallowNull:3}}}),Bridge.define("Newtonsoft.Json.Serialization.IContractResolver",{$kind:"interface"}),Bridge.define("Newtonsoft.Json.Serialization.ISerializationBinder",{$kind:"interface"}),Bridge.define("Newtonsoft.Json.TypeNameHandling",{$kind:"enum",statics:{fields:{None:0,Objects:1,Arrays:2,All:3,Auto:4}},$flags:!0}),Bridge.define("Newtonsoft.Json.Utils.AssemblyVersion",{statics:{fields:{version:null,compiler:null},ctors:{init:function(){this.version="1.17.0",this.compiler="17.10.0"}}}}),Bridge.define("Newtonsoft.Json.JsonSerializationException",{inherits:[Newtonsoft.Json.JsonException],ctors:{ctor:function(){this.$initialize(),Newtonsoft.Json.JsonException.ctor.call(this)},$ctor1:function(n){this.$initialize(),Newtonsoft.Json.JsonException.$ctor1.call(this,n)},$ctor2:function(n,t){this.$initialize(),Newtonsoft.Json.JsonException.$ctor2.call(this,n,t)}}}),Bridge.define("Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver",{inherits:[Newtonsoft.Json.Serialization.IContractResolver]}),Bridge.define("Newtonsoft.Json.JsonConvert",{statics:{methods:{stringify:function(n,t,o){return t===Newtonsoft.Json.Formatting.Indented?JSON.stringify(n,null,"  "):JSON.stringify(n)},parse:function(value){try{return JSON.parse(value)}catch(e){if(e instanceof SyntaxError)try{return eval("("+value+")")}catch(n){throw new Newtonsoft.Json.JsonException(n.message)}throw new Newtonsoft.Json.JsonException(e.message)}},getEnumerableElementType:function(n){var t,o,i;if(System.String.startsWith(n.$$name,"System.Collections.Generic.IEnumerable"))t=n;else for(o=Bridge.Reflection.getInterfaces(n),i=0;i<o.length;i++)if(System.String.startsWith(o[i].$$name,"System.Collections.Generic.IEnumerable")){t=o[i];break}return t?Bridge.Reflection.getGenericArguments(t)[0]:null},validateReflectable:function(n){do{var t=n===System.Object||n===Object||n.$literal||n.$kind==="anonymous",o=!Bridge.getMetadata(n);if(!t&&o)throw Bridge.$jsonGuard&&delete Bridge.$jsonGuard,new System.InvalidOperationException(Bridge.getTypeName(n)+" is not reflectable and cannot be serialized.");n=t?null:Bridge.Reflection.getBaseType(n)}while(!t&&n!=null)},defaultGuard:function(){Bridge.$jsonGuard&&Bridge.$jsonGuard.pop()},getValue:function(n,t){t=t.toLowerCase();for(var o in n)if(o.toLowerCase()==t)return n[o]},getCacheByType:function(n){for(var t,o,i=0;i<Newtonsoft.Json.$cache.length;i++)if(t=Newtonsoft.Json.$cache[i],t.type===n)return t;return o={type:n},Newtonsoft.Json.$cache.push(o),o},getMembers:function(n,t){var o=Newtonsoft.Json.JsonConvert.getCacheByType(n),i,l;return o[t]?o[t]:(i=Bridge.Reflection.getMembers(n,t,52),l=!1,i=i.map(function(s){var m=System.Attribute.getCustomAttributes(s,Newtonsoft.Json.JsonPropertyAttribute),r=System.Attribute.getCustomAttributes(s,System.ComponentModel.DefaultValueAttribute);return{member:s,attr:m&&m.length>0?m[0]:null,defaultValue:r&&r.length>0?r[0].Value:Bridge.getDefaultValue(s.rt)}}).filter(function(s){return!l&&s.attr&&s.attr.Order&&(l=!0),(s.attr||s.member.a===2)&&System.Attribute.getCustomAttributes(s.member,Newtonsoft.Json.JsonIgnoreAttribute).length===0}),l&&i.sort(function(s,m){return(s.attr&&s.attr.Order||0)-(m.attr&&m.attr.Order||0)}),o[t]=i,i)},preRawProcess:function(n,t,o,i){var l=n.attr,s=l&&l._defaultValueHandling!=null?l._defaultValueHandling:i.DefaultValueHandling,m=l&&l.Required;if(o===void 0&&(s===Newtonsoft.Json.DefaultValueHandling.Populate||s===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate)&&(o=n.defaultValue),(m===Newtonsoft.Json.Required.AllowNull||m===Newtonsoft.Json.Required.Always)&&o===void 0)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+n.member.n+"' not found in JSON.");if(m===Newtonsoft.Json.Required.Always&&o===null)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+n.member.n+"' expects a value but got null.");if(m===Newtonsoft.Json.Required.DisallowNull&&o===null)throw new Newtonsoft.Json.JsonSerializationException("Property '"+n.member.n+"' expects a value but got null.");return{value:o}},preProcess:function(n,t,o,i){var l=n.attr,s=l&&l._defaultValueHandling!=null?l._defaultValueHandling:i.DefaultValueHandling,m=l&&l._nullValueHandling!=null?l._nullValueHandling:i.NullValueHandling;if(o==null&&m===Newtonsoft.Json.NullValueHandling.Ignore)return!1;var r=Bridge.unbox(o,!0),J=n.defaultValue,u=r==null||J==null&&!(r==null&&J==null);return!u&&Bridge.equals(r,J)&&(s===Newtonsoft.Json.DefaultValueHandling.Ignore||s===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate)?!1:{value:o}},PopulateObject:function(n,t,o,i){var l,s,m,r,J,u,y,$,b,c;if(o=o||{},l=Bridge.getType(t),s=typeof n=="string"?Newtonsoft.Json.JsonConvert.parse(n):n,l.$nullable&&(l=l.$nullableType),s!=null&&typeof s=="object")if(Bridge.isArray(null,l)){if(s.length===void 0)return;for(u=0;u<s.length;u++)t.push(Newtonsoft.Json.JsonConvert.DeserializeObject(s[u],l.$elementType,o,!0))}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,l)){var G=System.Collections.Generic.Dictionary$2.getTypeParameters(l),R=G[0]||System.Object,v=G[1]||System.Object,x;if(Bridge.is(s,System.Collections.IDictionary))for(x=System.Linq.Enumerable.from(s.getKeys()).ToArray(),u=0;u<x.length;u++)m=x[u],t.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(m,R,o,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(s.get(m),v,o,!0),!1);else for(r in s)s.hasOwnProperty(r)&&t.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(r,R,o,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(s[r],v,o,!0),!1)}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,l)||Bridge.Reflection.isAssignableFrom(System.Collections.ICollection,l))for(J=System.Collections.Generic.List$1.getElementType(l)||System.Object,Bridge.isArray(s)||(s=s.ToArray?s.ToArray():Bridge.Collections.EnumerableHelpers.ToArray(J,s)),u=0;u<s.length;u++)t.add(Newtonsoft.Json.JsonConvert.DeserializeObject(s[u],J,o,!0));else{for(var O=o&&Bridge.is(o.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),I=Newtonsoft.Json.JsonConvert.getMembers(l,4),D=Newtonsoft.Json.JsonConvert.getMembers(l,16),n,T,f,d,C,u=0;u<I.length;u++)if(T=I[u],f=T.member,C=T.attr&&T.attr.PropertyName||(O?f.n.charAt(0).toLowerCase()+f.n.substr(1):f.n),n=s[C],n===void 0&&(n=Newtonsoft.Json.JsonConvert.getValue(s,C)),y=(i||s)[C],y===void 0&&(y=Newtonsoft.Json.JsonConvert.getValue(i||s,C)),c=Newtonsoft.Json.JsonConvert.preRawProcess(T,i||s,y,o),y=c.value,y!==void 0){var $=n===null||n===!1||n===!0||typeof n=="number"||typeof n=="string",b=Bridge.unbox(Bridge.Reflection.fieldAccess(f,t)),z=Newtonsoft.Json.JsonConvert.DeserializeObject(n,f.rt,o,!0),c=Newtonsoft.Json.JsonConvert.preProcess(T,t,b,o);c!==!1&&(b=c.value,$||b==null?Bridge.Reflection.fieldAccess(f,t,z):Newtonsoft.Json.JsonConvert.PopulateObject(z,b,o,n))}for(u=0;u<D.length;u++)T=D[u],d=T.member,C=T.attr&&T.attr.PropertyName||(O?d.n.charAt(0).toLowerCase()+d.n.substr(1):d.n),n=s[C],n===void 0&&(n=Newtonsoft.Json.JsonConvert.getValue(s,C)),y=(i||s)[C],y===void 0&&(y=Newtonsoft.Json.JsonConvert.getValue(i||s,C)),c=Newtonsoft.Json.JsonConvert.preRawProcess(T,i||s,y,o),y=c.value,y!==void 0&&($=n===null||n===!1||n===!0||typeof n=="number"||typeof n=="string",b=Bridge.unbox(Bridge.Reflection.midel(d.g,t)()),z=Newtonsoft.Json.JsonConvert.DeserializeObject(n,d.rt,o,!0),c=Newtonsoft.Json.JsonConvert.preProcess(T,t,b,o),c!==!1&&(b=c.value,$||b==null?d.s?Bridge.Reflection.midel(d.s,t)(z):type.$kind==="anonymous"&&(t[d.n]=z):Newtonsoft.Json.JsonConvert.PopulateObject(z,b,o,n)))}},BindToName:function(n,t){if(n&&n.SerializationBinder&&n.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName){var o={},i={};return n.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName(t,o,i),i.v+(o.v?", "+o.v:"")}return Bridge.Reflection.getTypeQName(t)},BindToType:function(n,t,o){var i;if(n&&n.SerializationBinder&&n.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType?(i=Newtonsoft.Json.JsonConvert.SplitFullyQualifiedTypeName(t),i=n.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType(i.assemblyName,i.typeName)):i=Bridge.Reflection.getType(t),!i)throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+t+"' was not resolved.");if(o&&!Bridge.Reflection.isAssignableFrom(o,i))throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+Bridge.Reflection.getTypeQName(i)+"' is not compatible with '"+Bridge.Reflection.getTypeQName(o)+"'.");return i},SplitFullyQualifiedTypeName:function(n){var t=Newtonsoft.Json.JsonConvert.GetAssemblyDelimiterIndex(n),o,i;return t!=null?(o=Newtonsoft.Json.JsonConvert.Trim(n,0,System.Nullable.getValueOrDefault(t,0)),i=Newtonsoft.Json.JsonConvert.Trim(n,System.Nullable.getValueOrDefault(t,0)+1|0,(n.length-System.Nullable.getValueOrDefault(t,0)|0)-1|0)):(o=n,i=null),{typeName:o,assemblyName:i}},GetAssemblyDelimiterIndex:function(n){for(var t,o=0,i=0;i<n.length;i=i+1|0)switch(t=n.charCodeAt(i),t){case 91:o=o+1|0;break;case 93:o=o-1|0;break;case 44:if(o===0)return i;break}return null},Trim:function(n,t,o){var i=(t+o|0)-1|0;if(i>=n.length)throw new System.ArgumentOutOfRangeException.$ctor1("length");for(;t<i&&System.Char.isWhiteSpace(String.fromCharCode(n.charCodeAt(t)));t=t+1|0);for(;i>=t&&System.Char.isWhiteSpace(String.fromCharCode(n.charCodeAt(i)));i=i-1|0);return n.substr(t,(i-t|0)+1|0)},SerializeObject:function(n,t,o,i,l,s){var m,r,J,u,y,$,b,c,G,R,v,x,O,I,D,T,f,d,C,z,N,k,B,g,a;if(Bridge.is(t,Newtonsoft.Json.JsonSerializerSettings)&&(o=t,t=0),n==null)return o&&o.NullValueHandling===Newtonsoft.Json.NullValueHandling.Ignore?void 0:i?null:Newtonsoft.Json.JsonConvert.stringify(null,t,o);if(m=Bridge.getType(n),l&&m&&(l.$kind==="interface"||Bridge.Reflection.isAssignableFrom(l,m))&&(l=null),l&&l.$nullable&&(l=l.$nullableType),l&&l===System.Char)return String.fromCharCode(n);if(r=l||m,typeof n=="function")return J=Bridge.getTypeName(n),i?J:Newtonsoft.Json.JsonConvert.stringify(J,t,o);if(typeof n=="object"){if($=Newtonsoft.Json.JsonConvert.defaultGuard,Bridge.$jsonGuard||(Bridge.$jsonGuard=[],$=function(){delete Bridge.$jsonGuard}),Bridge.$jsonGuard.indexOf(n)>-1)return;if(r===System.Globalization.CultureInfo||r===System.Guid||r===System.Uri||r===System.Int64||r===System.UInt64||r===System.Decimal||r===System.DateTime||r===System.DateTimeOffset||r===System.Char||Bridge.Reflection.isEnum(r)?$():Bridge.$jsonGuard.push(n),b=!1,n&&n.$boxed&&(n=Bridge.unbox(n,!0),b=!0),r===System.Globalization.CultureInfo)return i?n.name:Newtonsoft.Json.JsonConvert.stringify(n.name,t,o);if(r===System.Guid)return i?Bridge.toString(n):Newtonsoft.Json.JsonConvert.stringify(Bridge.toString(n),t,o);if(r===System.Uri)return i?n.getAbsoluteUri():Newtonsoft.Json.JsonConvert.stringify(n.getAbsoluteUri(),t,o);if(r===System.Int64||r===System.UInt64||r===System.Decimal)return i?n.toJSON():n.toString();if(r===System.DateTime)return c=System.DateTime.format(n,"yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),i?c:Newtonsoft.Json.JsonConvert.stringify(c,t,o);if(r===System.TimeSpan)return c=Bridge.toString(n),i?c:Newtonsoft.Json.JsonConvert.stringify(c,t,o);if(r===System.DateTimeOffset)return c=n.ToString$1("yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),i?c:Newtonsoft.Json.JsonConvert.stringify(c,t,o);if(Bridge.isArray(null,r)){if(r.$elementType===System.Byte)return $(),G=System.Convert.toBase64String(n),i?G:Newtonsoft.Json.JsonConvert.stringify(G,t,o);for(u=[],y=0;y<n.length;y++)u.push(Newtonsoft.Json.JsonConvert.SerializeObject(n[y],t,o,!0,r.$elementType));n=u,o&&o._typeNameHandling&&(f=o._typeNameHandling,d=f==2||f==3||f==4&&l&&l!==m,d&&(n={$type:Newtonsoft.Json.JsonConvert.BindToName(o,r),$values:u}))}else{if(Bridge.Reflection.isEnum(r))return s?System.Enum.getName(r,n):i?n:Newtonsoft.Json.JsonConvert.stringify(n,t,o);if(r===System.Char)return i?String.fromCharCode(n):Newtonsoft.Json.JsonConvert.stringify(String.fromCharCode(n),t,o);if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,r)){var _=System.Collections.Generic.Dictionary$2.getTypeParameters(r),h=_[0],A=_[1],w={},S=Bridge.getEnumerator(n);for(o&&o._typeNameHandling&&(f=o._typeNameHandling,d=f==1||f==3||f==4&&l&&l!==m,d&&(w.$type=Newtonsoft.Json.JsonConvert.BindToName(o,r)));S.moveNext();)R=S.Current,v=Newtonsoft.Json.JsonConvert.SerializeObject(R.key,t,o,!0,h,!0),typeof v=="object"&&(v=Bridge.toString(R.key)),w[v]=Newtonsoft.Json.JsonConvert.SerializeObject(R.value,t,o,!0,A);n=w}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,r)){for(x=Newtonsoft.Json.JsonConvert.getEnumerableElementType(r),O=Bridge.getEnumerator(n,x),u=[];O.moveNext();)I=O.Current,u.push(Newtonsoft.Json.JsonConvert.SerializeObject(I,t,o,!0,x));n=u,o&&o._typeNameHandling&&(f=o._typeNameHandling,d=f==2||f==3||f==4&&l&&l!==m,d&&(n={$type:Newtonsoft.Json.JsonConvert.BindToName(o,r),$values:u}))}else if(!b){if(D={},T=!Bridge.getMetadata(r),Newtonsoft.Json.JsonConvert.validateReflectable(r),o&&o._typeNameHandling&&(f=o._typeNameHandling,d=f==1||f==3||f==4&&l&&l!==m,d&&(D.$type=Newtonsoft.Json.JsonConvert.BindToName(o,r))),T)if(n.toJSON)D=n.toJSON();else for(C in n)n.hasOwnProperty(C)&&(D[C]=Newtonsoft.Json.JsonConvert.SerializeObject(n[C],t,o,!0));else{var H=Newtonsoft.Json.JsonConvert.getMembers(r,4),V=o&&Bridge.is(o.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),p=Bridge.Reflection.getMembers(r,8,54);if(p.length>0)for(a=0;a<p.length;a++)System.Attribute.isDefined(p[a],System.Runtime.Serialization.OnSerializingAttribute,!1)&&Bridge.Reflection.midel(p[a],n)(null);for(y=0;y<H.length;y++){var N=H[y],E=N.member,P=N.attr&&N.attr.PropertyName||(V?E.n.charAt(0).toLowerCase()+E.n.substr(1):E.n),M=Bridge.Reflection.fieldAccess(E,n),U=Newtonsoft.Json.JsonConvert.preProcess(N,n,M,o||{});U!==!1&&(N.attr&&(B=N.attr._typeNameHandling),B!=null&&(o=o||{},g=o._typeNameHandling,o._typeNameHandling=B),D[P]=Newtonsoft.Json.JsonConvert.SerializeObject(U.value,t,o,!0,E.rt),B!=null&&(o._typeNameHandling=g))}for(z=Newtonsoft.Json.JsonConvert.getMembers(r,16),y=0;y<z.length;y++)if(N=z[y],k=N.member,!!k.g){var L=N.attr&&N.attr.PropertyName||(V?k.n.charAt(0).toLowerCase()+k.n.substr(1):k.n),M=Bridge.Reflection.midel(k.g,n)(),U=Newtonsoft.Json.JsonConvert.preProcess(N,n,M,o||{});U!==!1&&(N.attr&&(B=N.attr._typeNameHandling),B!=null&&(o=o||{},g=o._typeNameHandling,o._typeNameHandling=B),D[L]=Newtonsoft.Json.JsonConvert.SerializeObject(U.value,t,o,!0,k.rt),B!=null&&(o._typeNameHandling=g))}if(p.length>0){for(a=0;a<p.length;a++)if(System.Attribute.isDefined(p[a],System.Runtime.Serialization.OnSerializedAttribute,!1)){Bridge.Reflection.midel(p[a],n)(null);break}}}n=D}}$()}else if(Bridge.Reflection.isEnum(r))return s?System.Enum.getName(r,n):i?n:Newtonsoft.Json.JsonConvert.stringify(n,t,o);return i?n:Newtonsoft.Json.JsonConvert.stringify(n,t,o)},getInstanceBuilder:function(n,t,o){var i=Bridge.isArray(t),l=i&&Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,n),s=typeof t=="object"&&!i,m=!1,r,J,u,y,$,b,c,G;if(l||s){var R=Bridge.Reflection.getMembers(n,1,54),v=[],x=!1,O=null;if(n===System.Version)R=[Bridge.Reflection.getMembers(n,1,284,null,[System.Int32,System.Int32,System.Int32,System.Int32])],O=R[0];else if(R.length>0)for(R=R.filter(function(B){return!B.isSynthetic}),r=0;r<R.length;r++){var I=R[r],D=System.Attribute.getCustomAttributes(I,Newtonsoft.Json.JsonConstructorAttribute).length>0,T=(I.pi||[]).length===0;if(T&&(x=!0),D){if(O!=null)throw new Newtonsoft.Json.JsonException("Multiple constructors with the JsonConstructorAttribute.");O=I}I.a===2&&v.push(I)}if(!x&&!O&&n.$kind==="struct"){if(J=!0,v.length>0){J=!1,O=v[0];var c=O.pi||[],f=Newtonsoft.Json.JsonConvert.getMembers(n,4),d=Newtonsoft.Json.JsonConvert.getMembers(n,16);for(u=0;u<c.length;u++){for(y=c[u],$=y.sn||y.n,b=0;b<d.length;b++){var C=d[u],z=C.member,N=C.attr&&C.attr.PropertyName||z.n;if($===N||$.toLowerCase()===N.toLowerCase()&&C.s){J=!0;break}}if(!J)for(b=0;b<f.length;b++){var C=f[u],k=C.member,N=C.attr&&C.attr.PropertyName||k.n;if($===N||$.toLowerCase()===N.toLowerCase()&&!C.ro){J=!0;break}}if(J)break}}J&&(O={td:n})}if(!x&&R.length>0){if(v.length!==1&&O==null)throw new Newtonsoft.Json.JsonSerializationException("Unable to find a constructor to use for type "+Bridge.getTypeName(n)+". A class should either have a default constructor or one constructor with arguments.");return O==null&&(O=v[0]),c=O.pi||[],l?function(B){var g=[],a,_,h,A,w,S,H,V,p,E,P,M;if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,c[0].pt)){if(a=[],_=Bridge.Reflection.getGenericArguments(c[0].pt)[0]||Bridge.Reflection.getGenericArguments(n)[0]||System.Object,o&&o._typeNameHandling&&B.length>0&&B[0]){if(A=!0,w=B[0].$type,w){for(H=1;H<B.length;H++)if(S=B[H]?B[H].$type:null,!S||S!==w){A=!1;break}}else A=!1;h=A?Newtonsoft.Json.JsonConvert.getInstanceBuilder(_,B[0],o):null}else h=null;for(H=0;H<B.length;H++)V=B[H],P=h&&!h.default,P&&(p=h(V),a[H]=p.value,E=p.names),a[H]=Newtonsoft.Json.JsonConvert.DeserializeObject(V,_,o,!0,P?a[H]:void 0,E);g.push(a),m=!0}return M=Bridge.Reflection.invokeCI(O,g),m?{$list:!0,names:[],value:M}:{names:[],value:M}}:function(B){for(var g,a=[],_=[],h=Object.getOwnPropertyNames(B),A=0;A<c.length;A++){var w=c[A],S=w.sn||w.n,H=null;for(g=0;g<h.length;g++)if(S===h[g]){H=h[g];break}if(!H){for(S=S.toLowerCase(),g=0;g<h.length;g++)if(S===h[g].toLowerCase()){H=h[g];break}}S=H,S?(a[A]=Newtonsoft.Json.JsonConvert.DeserializeObject(B[S],w.pt,o,!0),_.push(S)):a[A]=Bridge.getDefaultValue(w.pt)}return{names:_,value:Bridge.Reflection.invokeCI(O,a)}}}}return G=function(){return{names:[],value:Bridge.createInstance(n),default:!0}},G.default=!0,G},createInstance:function(n,t,o){var i=this.getInstanceBuilder(n,t,o);return i(t)},needReuse:function(n,t,o,i){return!!((n===Newtonsoft.Json.ObjectCreationHandling.Reuse||n===Newtonsoft.Json.ObjectCreationHandling.Auto&&t!=null)&&i&&o.$kind!=="struct"&&o.$kind!=="enum"&&o!==System.String&&o!==System.Boolean&&o!==System.Int64&&o!==System.UInt64&&o!==System.Int32&&o!==System.UInt32&&o!==System.Int16&&o!==System.UInt16&&o!==System.Byte&&o!==System.SByte&&o!==System.Single&&o!==System.Double&&o!==System.Decimal)},tryToGetCastOperator:function(n,t){var o,i,l,s,m;if(n===null)return null;if(typeof n=="boolean"||typeof n=="string")o=[Bridge.getType(n)];else if(typeof n=="number")o=[System.Double,System.Int64];else return null;for(i=0;i<o.length;i++){if(l=o[i],s=Bridge.Reflection.getMembers(t,8,284,"op_Explicit",[l]),s)return function(r){return Bridge.Reflection.midel(s,null)(r)};if(m=Bridge.Reflection.getMembers(t,8,284,"op_Implicit",[l]),m)return function(r){return Bridge.Reflection.midel(m,null)(r)}}return null},DeserializeObject:function(n,t,o,i,l,s){var m,r,J,u,y,$,b,c,G,R,v,x,O,I,D,T,f,d,C,z,N,k,B,g,a,_,h,A,w,S,H,V,p,E,P,M,U,L;if(o=o||{},t.$kind==="interface"&&(System.Collections.IDictionary===t?t=System.Collections.Generic.Dictionary$2(System.Object,System.Object):Bridge.Reflection.isGenericType(t)&&Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IDictionary$2,Bridge.Reflection.getGenericTypeDefinition(t))?(m=System.Collections.Generic.Dictionary$2.getTypeParameters(t),t=System.Collections.Generic.Dictionary$2(m[0]||System.Object,m[1]||System.Object)):t===System.Collections.IList||t===System.Collections.ICollection?t=System.Collections.Generic.List$1(System.Object):Bridge.Reflection.isGenericType(t)&&(Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IList$1,Bridge.Reflection.getGenericTypeDefinition(t))||Bridge.Reflection.isAssignableFrom(System.Collections.Generic.ICollection$1,Bridge.Reflection.getGenericTypeDefinition(t)))&&(t=System.Collections.Generic.List$1(System.Collections.Generic.List$1.getElementType(t)||System.Object))),i||typeof n!="string"||(r=Newtonsoft.Json.JsonConvert.parse(n),(typeof r=="object"||Bridge.isArray(r)||t===System.Array.type(System.Byte,1)||t===Function||t==System.Type||t===System.Guid||t===System.Globalization.CultureInfo||t===System.Uri||t===System.DateTime||t===System.DateTimeOffset||t===System.Char||Bridge.Reflection.isEnum(t))&&(n=r)),J=t===Object||t===System.Object,u=Bridge.isObject(n),J&&u&&n&&n.$type&&(y=Newtonsoft.Json.JsonConvert.BindToType(o,n.$type,t),t=y,J=!1),J&&u||t.$literal&&!Bridge.getMetadata(t))return Bridge.merge(J?{}:l||Bridge.createInstance(t),n);if($=Bridge.getDefaultValue(t),t.$nullable&&(t=t.$nullableType),n===null)return $;if(n===!1)return t===System.Boolean?!1:t===System.String?"false":(v=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(n,t),v?v(n):J?Bridge.box(n,System.Boolean,System.Boolean.toString):$);if(n===!0){if(t===System.Boolean)return!0;if(t===System.Int64)return System.Int64(1);if(t===System.UInt64)return System.UInt64(1);if(t===System.Decimal)return System.Decimal(1);if(t===String.String)return"true";if(t===System.DateTime)return System.DateTime.create$2(1,0);if(t===System.DateTimeOffset)return System.DateTimeOffset.MinValue.$clone();if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,1));if(typeof $=="number")return $+1;if(v=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(n,t),v)return v(n);if(J)return Bridge.box(n,System.Boolean,System.Boolean.toString);throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(n),Bridge.getTypeName(t)))}else if(typeof n=="number"){if(t.$number&&!t.$is(n)&&(t!==System.Decimal||!t.tryParse(n,null,{}))&&(!System.Int64.is64BitType(t)||!t.tryParse(n.toString(),{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",n,Bridge.getTypeName(t)));if(t===System.Boolean)return n!==0;if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,n));if(t===System.SByte)return n|0;if(t===System.Byte)return n>>>0;if(t===System.Int16)return n|0;if(t===System.UInt16)return n>>>0;if(t===System.Int32)return n|0;if(t===System.UInt32)return n>>>0;if(t===System.Int64)return System.Int64(n);if(t===System.UInt64)return System.UInt64(n);if(t===System.Single)return n;if(t===System.Double)return n;if(t===System.Decimal)return System.Decimal(n);if(t===System.Char)return n|0;if(t===System.String)return n.toString();if(t===System.DateTime)return System.DateTime.create$2(n|0,0);if(t===System.TimeSpan)return System.TimeSpan.fromTicks(n);if(t===System.DateTimeOffset)return new System.DateTimeOffset.$ctor5(System.Int64(n|0),new System.DateTimeOffset.ctor().Offset);if(v=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(n,t),v)return v(n);if(J)return Bridge.box(n,Bridge.getType(n));throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(n),Bridge.getTypeName(t)))}else if(typeof n=="string"){if(b=t===System.Decimal,c=b||System.Int64.is64BitType(t),c&&(b?!t.tryParse(n,null,{}):!t.tryParse(n,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",n,Bridge.getTypeName(t)));if(G=t==System.Double||t==System.Single,!c&&t.$number&&(G?!t.tryParse(n,null,{}):!t.tryParse(n,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Could not convert {0} to {1}: {2}",Bridge.getTypeName(n),Bridge.getTypeName(t),n));if(t===Function||t==System.Type)return Bridge.Reflection.getType(n);if(t===System.Globalization.CultureInfo)return new System.Globalization.CultureInfo(n);if(t===System.Uri)return new System.Uri(n);if(t===System.Guid)return System.Guid.Parse(n);if(t===System.Boolean)return R={v:!1},!System.String.isNullOrWhiteSpace(n)&&System.Boolean.tryParse(n,R)?R.v:!1;if(t===System.SByte)return n|0;if(t===System.Byte)return n>>>0;if(t===System.Int16)return n|0;if(t===System.UInt16)return n>>>0;if(t===System.Int32)return n|0;if(t===System.UInt32)return n>>>0;if(t===System.Int64)return System.Int64(n);if(t===System.UInt64)return System.UInt64(n);if(t===System.Single)return parseFloat(n);if(t===System.Double)return parseFloat(n);if(t===System.Decimal)try{return System.Decimal(n)}catch{return System.Decimal(0)}else{if(t===System.Char)return n.length===0?0:n.charCodeAt(0);if(t===System.String)return i?n:JSON.parse(n);if(t===System.TimeSpan)return System.TimeSpan.parse(n[0]=='"'?JSON.parse(n):n);if(t===System.DateTime){var q=System.String.endsWith(n,"Z"),j="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+(q?"'Z'":"K"),F=System.DateTime.parseExact(n,j,null,!0,!0);return F=F??System.DateTime.parse(n,void 0,!0),q&&F.kind!==1&&(F=System.DateTime.specifyKind(F,1)),F}else if(t===System.DateTimeOffset){var q=System.String.endsWith(n,"Z"),j="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+(q?"'Z'":"K"),F=System.DateTime.parseExact(n,j,null,!0,!0);return F=F??System.DateTime.parse(n,void 0,!0),q&&F.kind!==1&&(F=System.DateTime.specifyKind(F,1)),new System.DateTimeOffset.$ctor1(F)}else{if(Bridge.Reflection.isEnum(t))return Bridge.unbox(System.Enum.parse(t,n));if(t===System.Array.type(System.Byte,1))return System.Convert.fromBase64String(n);if(v=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(n,t),v)return v(n);if(J)return n;throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(n),Bridge.getTypeName(t)))}}}else if(typeof n=="object"){if($!==null&&t.$kind!=="struct")return $;if(Bridge.isArray(null,t)){if(f=n.$type,f!=null&&(t=Newtonsoft.Json.JsonConvert.BindToType(o,f,t),n=n.$values),n.length===void 0)return[];for(x=[],System.Array.type(t.$elementType,t.$rank||1,x),S=0;S<n.length;S++)x[S]=Newtonsoft.Json.JsonConvert.DeserializeObject(n[S],t.$elementType,o,!0);return x}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,t)){if(f=n.$type,f!=null&&(t=Newtonsoft.Json.JsonConvert.BindToType(o,f,t),n=n.$values),O=System.Collections.Generic.List$1.getElementType(t)||System.Object,I=l?{value:l}:Newtonsoft.Json.JsonConvert.createInstance(t,n,o),I&&I.$list)return I.value;if(I=I.value,n.length===void 0)return I;for(S=0;S<n.length;S++)I.add(Newtonsoft.Json.JsonConvert.DeserializeObject(n[S],O,o,!0));return I}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,t)){var W=System.Collections.Generic.Dictionary$2.getTypeParameters(t),Z=W[0]||System.Object,Q=W[1]||System.Object,z,f=n.$type,K=!1;if(f!=null&&(t=Newtonsoft.Json.JsonConvert.BindToType(o,f,t),K=!0),D=l?{value:l}:Newtonsoft.Json.JsonConvert.createInstance(t,n,o),D&&D.$list)return D.value;z=D.names||[],D=D.value;for(T in n)n.hasOwnProperty(T)&&(!K||T!=="$type")&&z.indexOf(T)<0&&D.add(Newtonsoft.Json.JsonConvert.DeserializeObject(T,Z,o,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(n[T],Q,o,!0));return D}else{if(f=n.$type,f!=null&&(t=Newtonsoft.Json.JsonConvert.BindToType(o,f,t)),!Bridge.getMetadata(t))return Bridge.merge(J?{}:l||Bridge.createInstance(t),n);if(d=l?{value:l,names:s,default:!0}:Newtonsoft.Json.JsonConvert.createInstance(t,n,o),z=d.names||[],C=d.default,d=d.value,N=Bridge.Reflection.getMembers(t,8,54),N.length>0)for(L=0;L<N.length;L++)System.Attribute.isDefined(N[L],System.Runtime.Serialization.OnDeserializingAttribute,!1)&&Bridge.Reflection.midel(N[L],d)(null);for(k=o&&Bridge.is(o.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),B=Newtonsoft.Json.JsonConvert.getMembers(t,4),S=0;S<B.length;S++)a=B[S],_=a.member,A=a.attr&&a.attr.PropertyName||(k?_.n.charAt(0).toLowerCase()+_.n.substr(1):_.n),z.indexOf(A)>-1||(g=n[A],g===void 0&&(g=Newtonsoft.Json.JsonConvert.getValue(n,A)),V=Newtonsoft.Json.JsonConvert.preRawProcess(a,n,g,o),g=V.value,g!==void 0&&(p=Bridge.Reflection.fieldAccess(_,d),E=Newtonsoft.Json.ObjectCreationHandling.Auto,w=void 0,a.attr&&a.attr._objectCreationHandling!=null?E=a.attr._objectCreationHandling:o._objectCreationHandling!=null&&(E=o._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(E,p,_.rt,C)&&(w=Bridge.unbox(p,!0)),a.attr&&(P=a.attr._typeNameHandling),P!=null&&(M=o._typeNameHandling,o._typeNameHandling=P),U=Newtonsoft.Json.JsonConvert.DeserializeObject(g,_.rt,o,!0,w),P!=null&&(o._typeNameHandling=M),V=Newtonsoft.Json.JsonConvert.preProcess(a,d,U,o),V!==!1&&w===void 0&&Bridge.Reflection.fieldAccess(_,d,V.value)));for(H=Newtonsoft.Json.JsonConvert.getMembers(t,16),S=0;S<H.length;S++)a=H[S],h=a.member,A=a.attr&&a.attr.PropertyName||(k?h.n.charAt(0).toLowerCase()+h.n.substr(1):h.n),z.indexOf(A)>-1||(g=n[A],g===void 0&&(g=Newtonsoft.Json.JsonConvert.getValue(n,A)),V=Newtonsoft.Json.JsonConvert.preRawProcess(a,n,g,o),g=V.value,g!==void 0&&(w=void 0,h.g&&(p=Bridge.Reflection.midel(h.g,d)(),E=Newtonsoft.Json.ObjectCreationHandling.Auto,a.attr&&a.attr._objectCreationHandling!=null?E=a.attr._objectCreationHandling:o._objectCreationHandling!=null&&(E=o._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(E,p,h.rt,C)&&(w=Bridge.unbox(p,!0))),a.attr&&(P=a.attr._typeNameHandling),P!=null&&(M=o._typeNameHandling,o._typeNameHandling=P),U=Newtonsoft.Json.JsonConvert.DeserializeObject(g,h.rt,o,!0,w),P!=null&&(o._typeNameHandling=M),V=Newtonsoft.Json.JsonConvert.preProcess(a,d,U,o),V!==!1&&w===void 0&&(h.s?Bridge.Reflection.midel(h.s,d)(V.value):t.$kind==="anonymous"&&(d[h.n]=V.value))));if(N.length>0)for(L=0;L<N.length;L++)System.Attribute.isDefined(N[L],System.Runtime.Serialization.OnDeserializedAttribute,!1)&&Bridge.Reflection.midel(N[L],d)(null);return d}}}}}}),Newtonsoft.Json.$cache=[]});

//# sourceMappingURL=newtonsoft.json.min.js.map