/*
 * @version   : 1.17.0 - A Bridge.NET implementation of Newtonsoft.Json
 * @author    : Object.NET, Inc. http://www.bridge.net/
 * @copyright : Copyright (c) 2008-2019, Object.NET, Inc. (http://www.object.net/). All rights reserved.
 * @license   : See license.txt and https://github.com/bridgedotnet/Bridge.NET/blob/master/LICENSE.
 */
Bridge.assembly("Newtonsoft.Json",function($asm,globals){"use strict";Bridge.define("Newtonsoft.Json.DefaultValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1,Populate:2,IgnoreAndPopulate:3}},$flags:!0});Bridge.define("Newtonsoft.Json.Formatting",{$kind:"enum",statics:{fields:{None:0,Indented:1}}});Bridge.define("Newtonsoft.Json.JsonConstructorAttribute",{inherits:[System.Attribute]});Bridge.define("Newtonsoft.Json.JsonException",{inherits:[System.Exception],ctors:{ctor:function(){this.$initialize();System.Exception.ctor.call(this)},$ctor1:function(message){this.$initialize();System.Exception.ctor.call(this,message)},$ctor2:function(message,innerException){this.$initialize();System.Exception.ctor.call(this,message,innerException)}}});Bridge.define("Newtonsoft.Json.JsonIgnoreAttribute",{inherits:[System.Attribute]});Bridge.define("Newtonsoft.Json.JsonPropertyAttribute",{inherits:[System.Attribute],fields:{_nullValueHandling:null,_defaultValueHandling:null,_objectCreationHandling:null,_typeNameHandling:null,_required:null,_order:null},props:{NullValueHandling:{get:function(){var $t;return $t=this._nullValueHandling,$t!=null?$t:0},set:function(value){this._nullValueHandling=value}},DefaultValueHandling:{get:function(){var $t;return $t=this._defaultValueHandling,$t!=null?$t:0},set:function(value){this._defaultValueHandling=value}},ObjectCreationHandling:{get:function(){var $t;return $t=this._objectCreationHandling,$t!=null?$t:0},set:function(value){this._objectCreationHandling=value}},TypeNameHandling:{get:function(){var $t;return $t=this._typeNameHandling,$t!=null?$t:0},set:function(value){this._typeNameHandling=value}},Required:{get:function(){var $t;return $t=this._required,$t!=null?$t:Newtonsoft.Json.Required.Default},set:function(value){this._required=value}},Order:{get:function(){var $t;return $t=this._order,$t!=null?$t:Bridge.getDefaultValue(System.Int32)},set:function(value){this._order=value}},PropertyName:null},ctors:{ctor:function(){this.$initialize();System.Attribute.ctor.call(this)},$ctor1:function(propertyName){this.$initialize();System.Attribute.ctor.call(this);this.PropertyName=propertyName}}});Bridge.define("Newtonsoft.Json.JsonSerializerSettings",{statics:{fields:{DefaultNullValueHandling:0,DefaultTypeNameHandling:0},ctors:{init:function(){this.DefaultNullValueHandling=Newtonsoft.Json.NullValueHandling.Include;this.DefaultTypeNameHandling=Newtonsoft.Json.TypeNameHandling.None}}},fields:{_defaultValueHandling:null,_typeNameHandling:null,_nullValueHandling:null,_objectCreationHandling:null},props:{NullValueHandling:{get:function(){var $t;return $t=this._nullValueHandling,$t!=null?$t:Newtonsoft.Json.JsonSerializerSettings.DefaultNullValueHandling},set:function(value){this._nullValueHandling=value}},ObjectCreationHandling:{get:function(){var $t;return $t=this._objectCreationHandling,$t!=null?$t:0},set:function(value){this._objectCreationHandling=value}},DefaultValueHandling:{get:function(){var $t;return $t=this._defaultValueHandling,$t!=null?$t:0},set:function(value){this._defaultValueHandling=value}},TypeNameHandling:{get:function(){var $t;return $t=this._typeNameHandling,$t!=null?$t:Newtonsoft.Json.JsonSerializerSettings.DefaultTypeNameHandling},set:function(value){this._typeNameHandling=value}},ContractResolver:null,SerializationBinder:null}});Bridge.define("Newtonsoft.Json.NullValueHandling",{$kind:"enum",statics:{fields:{Include:0,Ignore:1}}});Bridge.define("Newtonsoft.Json.ObjectCreationHandling",{$kind:"enum",statics:{fields:{Auto:0,Reuse:1,Replace:2}}});Bridge.define("Newtonsoft.Json.Required",{$kind:"enum",statics:{fields:{Default:0,AllowNull:1,Always:2,DisallowNull:3}}});Bridge.define("Newtonsoft.Json.Serialization.IContractResolver",{$kind:"interface"});Bridge.define("Newtonsoft.Json.Serialization.ISerializationBinder",{$kind:"interface"});Bridge.define("Newtonsoft.Json.TypeNameHandling",{$kind:"enum",statics:{fields:{None:0,Objects:1,Arrays:2,All:3,Auto:4}},$flags:!0});Bridge.define("Newtonsoft.Json.Utils.AssemblyVersion",{statics:{fields:{version:null,compiler:null},ctors:{init:function(){this.version="1.17.0";this.compiler="17.10.0"}}}});Bridge.define("Newtonsoft.Json.JsonSerializationException",{inherits:[Newtonsoft.Json.JsonException],ctors:{ctor:function(){this.$initialize();Newtonsoft.Json.JsonException.ctor.call(this)},$ctor1:function(message){this.$initialize();Newtonsoft.Json.JsonException.$ctor1.call(this,message)},$ctor2:function(message,innerException){this.$initialize();Newtonsoft.Json.JsonException.$ctor2.call(this,message,innerException)}}});Bridge.define("Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver",{inherits:[Newtonsoft.Json.Serialization.IContractResolver]});Bridge.define("Newtonsoft.Json.JsonConvert",{statics:{methods:{stringify:function(value,formatting,settings){return formatting===Newtonsoft.Json.Formatting.Indented?JSON.stringify(value,null,"  "):JSON.stringify(value)},parse:function(value){try{return JSON.parse(value)}catch(e){if(e instanceof SyntaxError)try{return eval("("+value+")")}catch(e){throw new Newtonsoft.Json.JsonException(e.message);}throw new Newtonsoft.Json.JsonException(e.message);}},getEnumerableElementType:function(type){var interfaceType,interfaces,j;if(System.String.startsWith(type.$$name,"System.Collections.Generic.IEnumerable"))interfaceType=type;else for(interfaces=Bridge.Reflection.getInterfaces(type),j=0;j<interfaces.length;j++)if(System.String.startsWith(interfaces[j].$$name,"System.Collections.Generic.IEnumerable")){interfaceType=interfaces[j];break}return interfaceType?Bridge.Reflection.getGenericArguments(interfaceType)[0]:null},validateReflectable:function(type){do{var ignoreMetaData=type===System.Object||type===Object||type.$literal||type.$kind==="anonymous",nometa=!Bridge.getMetadata(type);if(!ignoreMetaData&&nometa){Bridge.$jsonGuard&&delete Bridge.$jsonGuard;throw new System.InvalidOperationException(Bridge.getTypeName(type)+" is not reflectable and cannot be serialized.");}type=ignoreMetaData?null:Bridge.Reflection.getBaseType(type)}while(!ignoreMetaData&&type!=null)},defaultGuard:function(){Bridge.$jsonGuard&&Bridge.$jsonGuard.pop()},getValue:function(obj,name){name=name.toLowerCase();for(var key in obj)if(key.toLowerCase()==name)return obj[key]},getCacheByType:function(type){for(var t,cfg,i=0;i<Newtonsoft.Json.$cache.length;i++)if(t=Newtonsoft.Json.$cache[i],t.type===type)return t;return cfg={type:type},Newtonsoft.Json.$cache.push(cfg),cfg},getMembers:function(type,memberCode){var cache=Newtonsoft.Json.JsonConvert.getCacheByType(type),members,hasOrder;return cache[memberCode]?cache[memberCode]:(members=Bridge.Reflection.getMembers(type,memberCode,52),hasOrder=!1,members=members.map(function(m){var attr=System.Attribute.getCustomAttributes(m,Newtonsoft.Json.JsonPropertyAttribute),defValueAttr=System.Attribute.getCustomAttributes(m,System.ComponentModel.DefaultValueAttribute);return{member:m,attr:attr&&attr.length>0?attr[0]:null,defaultValue:defValueAttr&&defValueAttr.length>0?defValueAttr[0].Value:Bridge.getDefaultValue(m.rt)}}).filter(function(cfg){return!hasOrder&&cfg.attr&&cfg.attr.Order&&(hasOrder=!0),(cfg.attr||cfg.member.a===2)&&System.Attribute.getCustomAttributes(cfg.member,Newtonsoft.Json.JsonIgnoreAttribute).length===0}),hasOrder&&members.sort(function(a,b){return(a.attr&&a.attr.Order||0)-(b.attr&&b.attr.Order||0)}),cache[memberCode]=members,members)},preRawProcess:function(cfg,instance,value,settings){var attr=cfg.attr,defaultValueHandling=attr&&attr._defaultValueHandling!=null?attr._defaultValueHandling:settings.DefaultValueHandling,required=attr&&attr.Required;if(value===undefined&&(defaultValueHandling===Newtonsoft.Json.DefaultValueHandling.Populate||defaultValueHandling===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate)&&(value=cfg.defaultValue),(required===Newtonsoft.Json.Required.AllowNull||required===Newtonsoft.Json.Required.Always)&&value===undefined)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+cfg.member.n+"' not found in JSON.");if(required===Newtonsoft.Json.Required.Always&&value===null)throw new Newtonsoft.Json.JsonSerializationException("Required property '"+cfg.member.n+"' expects a value but got null.");if(required===Newtonsoft.Json.Required.DisallowNull&&value===null)throw new Newtonsoft.Json.JsonSerializationException("Property '"+cfg.member.n+"' expects a value but got null.");return{value:value}},preProcess:function(cfg,instance,value,settings){var attr=cfg.attr,defaultValueHandling=attr&&attr._defaultValueHandling!=null?attr._defaultValueHandling:settings.DefaultValueHandling,nullValueHandling=attr&&attr._nullValueHandling!=null?attr._nullValueHandling:settings.NullValueHandling;if(value==null&&nullValueHandling===Newtonsoft.Json.NullValueHandling.Ignore)return!1;var x=Bridge.unbox(value,!0),y=cfg.defaultValue,oneNull=x==null||y==null&&!(x==null&&y==null);return!oneNull&&Bridge.equals(x,y)&&(defaultValueHandling===Newtonsoft.Json.DefaultValueHandling.Ignore||defaultValueHandling===Newtonsoft.Json.DefaultValueHandling.IgnoreAndPopulate)?!1:{value:value}},PopulateObject:function(value,target,settings,schema){var targetType,raw,key,each,typeElement,i,inSchema,needSet,targetValue,result;if(settings=settings||{},targetType=Bridge.getType(target),raw=typeof value=="string"?Newtonsoft.Json.JsonConvert.parse(value):value,targetType.$nullable&&(targetType=targetType.$nullableType),raw!=null&&typeof raw=="object")if(Bridge.isArray(null,targetType)){if(raw.length===undefined)return;for(i=0;i<raw.length;i++)target.push(Newtonsoft.Json.JsonConvert.DeserializeObject(raw[i],targetType.$elementType,settings,!0))}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,targetType)){var typesGeneric=System.Collections.Generic.Dictionary$2.getTypeParameters(targetType),typeKey=typesGeneric[0]||System.Object,typeValue=typesGeneric[1]||System.Object,keys;if(Bridge.is(raw,System.Collections.IDictionary))for(keys=System.Linq.Enumerable.from(raw.getKeys()).ToArray(),i=0;i<keys.length;i++)key=keys[i],target.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(key,typeKey,settings,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(raw.get(key),typeValue,settings,!0),!1);else for(each in raw)raw.hasOwnProperty(each)&&target.setItem(Newtonsoft.Json.JsonConvert.DeserializeObject(each,typeKey,settings,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(raw[each],typeValue,settings,!0),!1)}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,targetType)||Bridge.Reflection.isAssignableFrom(System.Collections.ICollection,targetType))for(typeElement=System.Collections.Generic.List$1.getElementType(targetType)||System.Object,Bridge.isArray(raw)||(raw=raw.ToArray?raw.ToArray():Bridge.Collections.EnumerableHelpers.ToArray(typeElement,raw)),i=0;i<raw.length;i++)target.add(Newtonsoft.Json.JsonConvert.DeserializeObject(raw[i],typeElement,settings,!0));else{for(var camelCase=settings&&Bridge.is(settings.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),fields=Newtonsoft.Json.JsonConvert.getMembers(targetType,4),properties=Newtonsoft.Json.JsonConvert.getMembers(targetType,16),value,cfg,f,p,mname,i=0;i<fields.length;i++)if(cfg=fields[i],f=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||(camelCase?f.n.charAt(0).toLowerCase()+f.n.substr(1):f.n),value=raw[mname],value===undefined&&(value=Newtonsoft.Json.JsonConvert.getValue(raw,mname)),inSchema=(schema||raw)[mname],inSchema===undefined&&(inSchema=Newtonsoft.Json.JsonConvert.getValue(schema||raw,mname)),result=Newtonsoft.Json.JsonConvert.preRawProcess(cfg,schema||raw,inSchema,settings),inSchema=result.value,inSchema!==undefined){var needSet=value===null||value===!1||value===!0||typeof value=="number"||typeof value=="string",targetValue=Bridge.unbox(Bridge.Reflection.fieldAccess(f,target)),instance=Newtonsoft.Json.JsonConvert.DeserializeObject(value,f.rt,settings,!0),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,target,targetValue,settings);result!==!1&&(targetValue=result.value,needSet||targetValue==null?Bridge.Reflection.fieldAccess(f,target,instance):Newtonsoft.Json.JsonConvert.PopulateObject(instance,targetValue,settings,value))}for(i=0;i<properties.length;i++)cfg=properties[i],p=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||(camelCase?p.n.charAt(0).toLowerCase()+p.n.substr(1):p.n),value=raw[mname],value===undefined&&(value=Newtonsoft.Json.JsonConvert.getValue(raw,mname)),inSchema=(schema||raw)[mname],inSchema===undefined&&(inSchema=Newtonsoft.Json.JsonConvert.getValue(schema||raw,mname)),result=Newtonsoft.Json.JsonConvert.preRawProcess(cfg,schema||raw,inSchema,settings),inSchema=result.value,inSchema!==undefined&&(needSet=value===null||value===!1||value===!0||typeof value=="number"||typeof value=="string",targetValue=Bridge.unbox(Bridge.Reflection.midel(p.g,target)()),instance=Newtonsoft.Json.JsonConvert.DeserializeObject(value,p.rt,settings,!0),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,target,targetValue,settings),result!==!1&&(targetValue=result.value,needSet||targetValue==null?p.s?Bridge.Reflection.midel(p.s,target)(instance):type.$kind==="anonymous"&&(target[p.n]=instance):Newtonsoft.Json.JsonConvert.PopulateObject(instance,targetValue,settings,value)))}},BindToName:function(settings,type){if(settings&&settings.SerializationBinder&&settings.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName){var asm={},name={};return settings.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToName(type,asm,name),name.v+(asm.v?", "+asm.v:"")}return Bridge.Reflection.getTypeQName(type)},BindToType:function(settings,fullName,objectType){var type;if(settings&&settings.SerializationBinder&&settings.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType?(type=Newtonsoft.Json.JsonConvert.SplitFullyQualifiedTypeName(fullName),type=settings.SerializationBinder.Newtonsoft$Json$Serialization$ISerializationBinder$BindToType(type.assemblyName,type.typeName)):type=Bridge.Reflection.getType(fullName),!type)throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+fullName+"' was not resolved.");if(objectType&&!Bridge.Reflection.isAssignableFrom(objectType,type))throw new Newtonsoft.Json.JsonSerializationException("Type specified in JSON '"+Bridge.Reflection.getTypeQName(type)+"' is not compatible with '"+Bridge.Reflection.getTypeQName(objectType)+"'.");return type},SplitFullyQualifiedTypeName:function(fullyQualifiedTypeName){var assemblyDelimiterIndex=Newtonsoft.Json.JsonConvert.GetAssemblyDelimiterIndex(fullyQualifiedTypeName),typeName,assemblyName;return assemblyDelimiterIndex!=null?(typeName=Newtonsoft.Json.JsonConvert.Trim(fullyQualifiedTypeName,0,System.Nullable.getValueOrDefault(assemblyDelimiterIndex,0)),assemblyName=Newtonsoft.Json.JsonConvert.Trim(fullyQualifiedTypeName,System.Nullable.getValueOrDefault(assemblyDelimiterIndex,0)+1|0,(fullyQualifiedTypeName.length-System.Nullable.getValueOrDefault(assemblyDelimiterIndex,0)|0)-1|0)):(typeName=fullyQualifiedTypeName,assemblyName=null),{typeName:typeName,assemblyName:assemblyName}},GetAssemblyDelimiterIndex:function(fullyQualifiedTypeName){for(var current,scope=0,i=0;i<fullyQualifiedTypeName.length;i=i+1|0){current=fullyQualifiedTypeName.charCodeAt(i);switch(current){case 91:scope=scope+1|0;break;case 93:scope=scope-1|0;break;case 44:if(scope===0)return i;break}}return null},Trim:function(s,start,length){var end=(start+length|0)-1|0;if(end>=s.length)throw new System.ArgumentOutOfRangeException.$ctor1("length");for(;start<end;start=start+1|0)if(!System.Char.isWhiteSpace(String.fromCharCode(s.charCodeAt(start))))break;for(;end>=start;end=end-1|0)if(!System.Char.isWhiteSpace(String.fromCharCode(s.charCodeAt(end))))break;return s.substr(start,(end-start|0)+1|0)},SerializeObject:function(obj,formatting,settings,returnRaw,possibleType,dictKey){var objType,type,name,arr,i,removeGuard,wasBoxed,d,json,entr,keyJson,typeElement,enumerator,item,raw,nometa,handling,writeType,key,properties,cfg,p,typeNameHandling,oldTypeNameHandling,midx;if(Bridge.is(formatting,Newtonsoft.Json.JsonSerializerSettings)&&(settings=formatting,formatting=0),obj==null)return settings&&settings.NullValueHandling===Newtonsoft.Json.NullValueHandling.Ignore?void 0:returnRaw?null:Newtonsoft.Json.JsonConvert.stringify(null,formatting,settings);if(objType=Bridge.getType(obj),possibleType&&objType&&(possibleType.$kind==="interface"||Bridge.Reflection.isAssignableFrom(possibleType,objType))&&(possibleType=null),possibleType&&possibleType.$nullable&&(possibleType=possibleType.$nullableType),possibleType&&possibleType===System.Char)return String.fromCharCode(obj);if(type=possibleType||objType,typeof obj=="function")return name=Bridge.getTypeName(obj),returnRaw?name:Newtonsoft.Json.JsonConvert.stringify(name,formatting,settings);else if(typeof obj=="object"){if(removeGuard=Newtonsoft.Json.JsonConvert.defaultGuard,Bridge.$jsonGuard||(Bridge.$jsonGuard=[],removeGuard=function(){delete Bridge.$jsonGuard}),Bridge.$jsonGuard.indexOf(obj)>-1)return;if(type===System.Globalization.CultureInfo||type===System.Guid||type===System.Uri||type===System.Int64||type===System.UInt64||type===System.Decimal||type===System.DateTime||type===System.DateTimeOffset||type===System.Char||Bridge.Reflection.isEnum(type)?removeGuard():Bridge.$jsonGuard.push(obj),wasBoxed=!1,obj&&obj.$boxed&&(obj=Bridge.unbox(obj,!0),wasBoxed=!0),type===System.Globalization.CultureInfo)return returnRaw?obj.name:Newtonsoft.Json.JsonConvert.stringify(obj.name,formatting,settings);else if(type===System.Guid)return returnRaw?Bridge.toString(obj):Newtonsoft.Json.JsonConvert.stringify(Bridge.toString(obj),formatting,settings);else if(type===System.Uri)return returnRaw?obj.getAbsoluteUri():Newtonsoft.Json.JsonConvert.stringify(obj.getAbsoluteUri(),formatting,settings);else if(type===System.Int64||type===System.UInt64||type===System.Decimal)return returnRaw?obj.toJSON():obj.toString();else if(type===System.DateTime)return d=System.DateTime.format(obj,"yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),returnRaw?d:Newtonsoft.Json.JsonConvert.stringify(d,formatting,settings);else if(type===System.TimeSpan)return d=Bridge.toString(obj),returnRaw?d:Newtonsoft.Json.JsonConvert.stringify(d,formatting,settings);else if(type===System.DateTimeOffset)return d=obj.ToString$1("yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFFK"),returnRaw?d:Newtonsoft.Json.JsonConvert.stringify(d,formatting,settings);else if(Bridge.isArray(null,type)){if(type.$elementType===System.Byte)return removeGuard(),json=System.Convert.toBase64String(obj),returnRaw?json:Newtonsoft.Json.JsonConvert.stringify(json,formatting,settings);for(arr=[],i=0;i<obj.length;i++)arr.push(Newtonsoft.Json.JsonConvert.SerializeObject(obj[i],formatting,settings,!0,type.$elementType));obj=arr;settings&&settings._typeNameHandling&&(handling=settings._typeNameHandling,writeType=handling==2||handling==3||handling==4&&possibleType&&possibleType!==objType,writeType&&(obj={$type:Newtonsoft.Json.JsonConvert.BindToName(settings,type),$values:arr}))}else if(Bridge.Reflection.isEnum(type))return dictKey?System.Enum.getName(type,obj):returnRaw?obj:Newtonsoft.Json.JsonConvert.stringify(obj,formatting,settings);else if(type===System.Char)return returnRaw?String.fromCharCode(obj):Newtonsoft.Json.JsonConvert.stringify(String.fromCharCode(obj),formatting,settings);else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,type)){var typesGeneric=System.Collections.Generic.Dictionary$2.getTypeParameters(type),typeKey=typesGeneric[0],typeValue=typesGeneric[1],dict={},enm=Bridge.getEnumerator(obj);for(settings&&settings._typeNameHandling&&(handling=settings._typeNameHandling,writeType=handling==1||handling==3||handling==4&&possibleType&&possibleType!==objType,writeType&&(dict.$type=Newtonsoft.Json.JsonConvert.BindToName(settings,type)));enm.moveNext();)entr=enm.Current,keyJson=Newtonsoft.Json.JsonConvert.SerializeObject(entr.key,formatting,settings,!0,typeKey,!0),typeof keyJson=="object"&&(keyJson=Bridge.toString(entr.key)),dict[keyJson]=Newtonsoft.Json.JsonConvert.SerializeObject(entr.value,formatting,settings,!0,typeValue);obj=dict}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,type)){for(typeElement=Newtonsoft.Json.JsonConvert.getEnumerableElementType(type),enumerator=Bridge.getEnumerator(obj,typeElement),arr=[];enumerator.moveNext();)item=enumerator.Current,arr.push(Newtonsoft.Json.JsonConvert.SerializeObject(item,formatting,settings,!0,typeElement));obj=arr;settings&&settings._typeNameHandling&&(handling=settings._typeNameHandling,writeType=handling==2||handling==3||handling==4&&possibleType&&possibleType!==objType,writeType&&(obj={$type:Newtonsoft.Json.JsonConvert.BindToName(settings,type),$values:arr}))}else if(!wasBoxed){if(raw={},nometa=!Bridge.getMetadata(type),Newtonsoft.Json.JsonConvert.validateReflectable(type),settings&&settings._typeNameHandling&&(handling=settings._typeNameHandling,writeType=handling==1||handling==3||handling==4&&possibleType&&possibleType!==objType,writeType&&(raw.$type=Newtonsoft.Json.JsonConvert.BindToName(settings,type))),nometa)if(obj.toJSON)raw=obj.toJSON();else for(key in obj)obj.hasOwnProperty(key)&&(raw[key]=Newtonsoft.Json.JsonConvert.SerializeObject(obj[key],formatting,settings,!0));else{var fields=Newtonsoft.Json.JsonConvert.getMembers(type,4),camelCase=settings&&Bridge.is(settings.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),methods=Bridge.Reflection.getMembers(type,8,54);if(methods.length>0)for(midx=0;midx<methods.length;midx++)System.Attribute.isDefined(methods[midx],System.Runtime.Serialization.OnSerializingAttribute,!1)&&Bridge.Reflection.midel(methods[midx],obj)(null);for(i=0;i<fields.length;i++){var cfg=fields[i],f=cfg.member,fname=cfg.attr&&cfg.attr.PropertyName||(camelCase?f.n.charAt(0).toLowerCase()+f.n.substr(1):f.n),value=Bridge.Reflection.fieldAccess(f,obj),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,obj,value,settings||{});result!==!1&&(cfg.attr&&(typeNameHandling=cfg.attr._typeNameHandling),typeNameHandling!=null&&(settings=settings||{},oldTypeNameHandling=settings._typeNameHandling,settings._typeNameHandling=typeNameHandling),raw[fname]=Newtonsoft.Json.JsonConvert.SerializeObject(result.value,formatting,settings,!0,f.rt),typeNameHandling!=null&&(settings._typeNameHandling=oldTypeNameHandling))}for(properties=Newtonsoft.Json.JsonConvert.getMembers(type,16),i=0;i<properties.length;i++)if(cfg=properties[i],p=cfg.member,!!p.g){var pname=cfg.attr&&cfg.attr.PropertyName||(camelCase?p.n.charAt(0).toLowerCase()+p.n.substr(1):p.n),value=Bridge.Reflection.midel(p.g,obj)(),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,obj,value,settings||{});result!==!1&&(cfg.attr&&(typeNameHandling=cfg.attr._typeNameHandling),typeNameHandling!=null&&(settings=settings||{},oldTypeNameHandling=settings._typeNameHandling,settings._typeNameHandling=typeNameHandling),raw[pname]=Newtonsoft.Json.JsonConvert.SerializeObject(result.value,formatting,settings,!0,p.rt),typeNameHandling!=null&&(settings._typeNameHandling=oldTypeNameHandling))}if(methods.length>0)for(midx=0;midx<methods.length;midx++)if(System.Attribute.isDefined(methods[midx],System.Runtime.Serialization.OnSerializedAttribute,!1)){Bridge.Reflection.midel(methods[midx],obj)(null);break}}obj=raw}removeGuard()}else if(Bridge.Reflection.isEnum(type))return dictKey?System.Enum.getName(type,obj):returnRaw?obj:Newtonsoft.Json.JsonConvert.stringify(obj,formatting,settings);return returnRaw?obj:Newtonsoft.Json.JsonConvert.stringify(obj,formatting,settings)},getInstanceBuilder:function(type,raw,settings){var rawIsArray=Bridge.isArray(raw),isEnumerable=rawIsArray&&Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,type),isObject=typeof raw=="object"&&!rawIsArray,isList=!1,idx,useDefault,i,prm,name,j,params,fn;if(isEnumerable||isObject){var ctors=Bridge.Reflection.getMembers(type,1,54),publicCtors=[],hasDefault=!1,jsonCtor=null;if(type===System.Version)ctors=[Bridge.Reflection.getMembers(type,1,284,null,[System.Int32,System.Int32,System.Int32,System.Int32])],jsonCtor=ctors[0];else if(ctors.length>0)for(ctors=ctors.filter(function(c){return!c.isSynthetic}),idx=0;idx<ctors.length;idx++){var c=ctors[idx],hasAttribute=System.Attribute.getCustomAttributes(c,Newtonsoft.Json.JsonConstructorAttribute).length>0,isDefault=(c.pi||[]).length===0;if(isDefault&&(hasDefault=!0),hasAttribute){if(jsonCtor!=null)throw new Newtonsoft.Json.JsonException("Multiple constructors with the JsonConstructorAttribute.");jsonCtor=c}c.a===2&&publicCtors.push(c)}if(!hasDefault&&!jsonCtor&&type.$kind==="struct"){if(useDefault=!0,publicCtors.length>0){useDefault=!1;jsonCtor=publicCtors[0];var params=jsonCtor.pi||[],fields=Newtonsoft.Json.JsonConvert.getMembers(type,4),properties=Newtonsoft.Json.JsonConvert.getMembers(type,16);for(i=0;i<params.length;i++){for(prm=params[i],name=prm.sn||prm.n,j=0;j<properties.length;j++){var cfg=properties[i],p=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||p.n;if(name===mname||name.toLowerCase()===mname.toLowerCase()&&cfg.s){useDefault=!0;break}}if(!useDefault)for(j=0;j<fields.length;j++){var cfg=fields[i],f=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||f.n;if(name===mname||name.toLowerCase()===mname.toLowerCase()&&!cfg.ro){useDefault=!0;break}}if(useDefault)break}}useDefault&&(jsonCtor={td:type})}if(!hasDefault&&ctors.length>0){if(publicCtors.length!==1&&jsonCtor==null)throw new Newtonsoft.Json.JsonSerializationException("Unable to find a constructor to use for type "+Bridge.getTypeName(type)+". A class should either have a default constructor or one constructor with arguments.");return(jsonCtor==null&&(jsonCtor=publicCtors[0]),params=jsonCtor.pi||[],isEnumerable)?function(raw){var args=[],arr,elementType,commonElementInstanceBuilder,useSameInstanceBuilderForAllValues,firstElementTypeName,nextElementTypeName,i,item,inst,names,useBuilder,v;if(Bridge.Reflection.isAssignableFrom(System.Collections.IEnumerable,params[0].pt)){if(arr=[],elementType=Bridge.Reflection.getGenericArguments(params[0].pt)[0]||Bridge.Reflection.getGenericArguments(type)[0]||System.Object,settings&&settings._typeNameHandling&&raw.length>0&&raw[0]){if(useSameInstanceBuilderForAllValues=!0,firstElementTypeName=raw[0].$type,firstElementTypeName){for(i=1;i<raw.length;i++)if(nextElementTypeName=raw[i]?raw[i].$type:null,!nextElementTypeName||nextElementTypeName!==firstElementTypeName){useSameInstanceBuilderForAllValues=!1;break}}else useSameInstanceBuilderForAllValues=!1;commonElementInstanceBuilder=useSameInstanceBuilderForAllValues?Newtonsoft.Json.JsonConvert.getInstanceBuilder(elementType,raw[0],settings):null}else commonElementInstanceBuilder=null;for(i=0;i<raw.length;i++)item=raw[i],useBuilder=commonElementInstanceBuilder&&!commonElementInstanceBuilder.default,useBuilder&&(inst=commonElementInstanceBuilder(item),arr[i]=inst.value,names=inst.names),arr[i]=Newtonsoft.Json.JsonConvert.DeserializeObject(item,elementType,settings,!0,useBuilder?arr[i]:undefined,names);args.push(arr);isList=!0}return v=Bridge.Reflection.invokeCI(jsonCtor,args),isList?{$list:!0,names:[],value:v}:{names:[],value:v}}:function(raw){for(var j,args=[],names=[],keys=Object.getOwnPropertyNames(raw),i=0;i<params.length;i++){var prm=params[i],name=prm.sn||prm.n,foundName=null;for(j=0;j<keys.length;j++)if(name===keys[j]){foundName=keys[j];break}if(!foundName)for(name=name.toLowerCase(),j=0;j<keys.length;j++)if(name===keys[j].toLowerCase()){foundName=keys[j];break}name=foundName;name?(args[i]=Newtonsoft.Json.JsonConvert.DeserializeObject(raw[name],prm.pt,settings,!0),names.push(name)):args[i]=Bridge.getDefaultValue(prm.pt)}return{names:names,value:Bridge.Reflection.invokeCI(jsonCtor,args)}}}}return fn=function(){return{names:[],value:Bridge.createInstance(type),"default":!0}},fn.default=!0,fn},createInstance:function(type,raw,settings){var builder=this.getInstanceBuilder(type,raw,settings);return builder(raw)},needReuse:function(objectCreationHandling,value,type,isDefCtor){return(objectCreationHandling===Newtonsoft.Json.ObjectCreationHandling.Reuse||objectCreationHandling===Newtonsoft.Json.ObjectCreationHandling.Auto&&value!=null)&&isDefCtor&&type.$kind!=="struct"&&type.$kind!=="enum"&&type!==System.String&&type!==System.Boolean&&type!==System.Int64&&type!==System.UInt64&&type!==System.Int32&&type!==System.UInt32&&type!==System.Int16&&type!==System.UInt16&&type!==System.Byte&&type!==System.SByte&&type!==System.Single&&type!==System.Double&&type!==System.Decimal?!0:!1},tryToGetCastOperator:function(raw,type){var typesToLookFor,i,typeToLookFor,explicitCastOnTarget,implicitCastOnTarget;if(raw===null)return null;if(typeof raw=="boolean"||typeof raw=="string")typesToLookFor=[Bridge.getType(raw)];else if(typeof raw=="number")typesToLookFor=[System.Double,System.Int64];else return null;for(i=0;i<typesToLookFor.length;i++){if(typeToLookFor=typesToLookFor[i],explicitCastOnTarget=Bridge.Reflection.getMembers(type,8,284,"op_Explicit",[typeToLookFor]),explicitCastOnTarget)return function(value){return Bridge.Reflection.midel(explicitCastOnTarget,null)(value)};if(implicitCastOnTarget=Bridge.Reflection.getMembers(type,8,284,"op_Implicit",[typeToLookFor]),implicitCastOnTarget)return function(value){return Bridge.Reflection.midel(implicitCastOnTarget,null)(value)}}return null},DeserializeObject:function(raw,type,settings,field,instance,i_names){var tPrms,obj,isObject,fromObject,realType,def,isDecimal,isSpecial,isFloat,parsed,castOperator,arr,typeElement,list,dictionary,each,typeName,o,isDefCtor,names,methods,camelCase,fields,value,cfg,f,p,mname,finst,i,properties,result,currentValue,objectCreationHandling,typeNameHandling,oldTypeNameHandling,svalue,midx;if(settings=settings||{},type.$kind==="interface"&&(System.Collections.IDictionary===type?type=System.Collections.Generic.Dictionary$2(System.Object,System.Object):Bridge.Reflection.isGenericType(type)&&Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IDictionary$2,Bridge.Reflection.getGenericTypeDefinition(type))?(tPrms=System.Collections.Generic.Dictionary$2.getTypeParameters(type),type=System.Collections.Generic.Dictionary$2(tPrms[0]||System.Object,tPrms[1]||System.Object)):type===System.Collections.IList||type===System.Collections.ICollection?type=System.Collections.Generic.List$1(System.Object):Bridge.Reflection.isGenericType(type)&&(Bridge.Reflection.isAssignableFrom(System.Collections.Generic.IList$1,Bridge.Reflection.getGenericTypeDefinition(type))||Bridge.Reflection.isAssignableFrom(System.Collections.Generic.ICollection$1,Bridge.Reflection.getGenericTypeDefinition(type)))&&(type=System.Collections.Generic.List$1(System.Collections.Generic.List$1.getElementType(type)||System.Object))),field||typeof raw!="string"||(obj=Newtonsoft.Json.JsonConvert.parse(raw),(typeof obj=="object"||Bridge.isArray(obj)||type===System.Array.type(System.Byte,1)||type===Function||type==System.Type||type===System.Guid||type===System.Globalization.CultureInfo||type===System.Uri||type===System.DateTime||type===System.DateTimeOffset||type===System.Char||Bridge.Reflection.isEnum(type))&&(raw=obj)),isObject=type===Object||type===System.Object,fromObject=Bridge.isObject(raw),isObject&&fromObject&&raw&&raw.$type&&(realType=Newtonsoft.Json.JsonConvert.BindToType(settings,raw.$type,type),type=realType,isObject=!1),isObject&&fromObject||type.$literal&&!Bridge.getMetadata(type))return Bridge.merge(isObject?{}:instance||Bridge.createInstance(type),raw);if(def=Bridge.getDefaultValue(type),type.$nullable&&(type=type.$nullableType),raw===null)return def;else if(raw===!1)return type===System.Boolean?!1:type===System.String?"false":(castOperator=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(raw,type),castOperator)?castOperator(raw):isObject?Bridge.box(raw,System.Boolean,System.Boolean.toString):def;else if(raw===!0)if(type===System.Boolean)return!0;else if(type===System.Int64)return System.Int64(1);else if(type===System.UInt64)return System.UInt64(1);else if(type===System.Decimal)return System.Decimal(1);else if(type===String.String)return"true";else if(type===System.DateTime)return System.DateTime.create$2(1,0);else if(type===System.DateTimeOffset)return System.DateTimeOffset.MinValue.$clone();else if(Bridge.Reflection.isEnum(type))return Bridge.unbox(System.Enum.parse(type,1));else{if(typeof def=="number")return def+1;if(castOperator=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(raw,type),castOperator)return castOperator(raw);if(isObject)return Bridge.box(raw,System.Boolean,System.Boolean.toString);throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(raw),Bridge.getTypeName(type)));}else if(typeof raw=="number"){if(type.$number&&!type.$is(raw)&&(type!==System.Decimal||!type.tryParse(raw,null,{}))&&(!System.Int64.is64BitType(type)||!type.tryParse(raw.toString(),{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",raw,Bridge.getTypeName(type)));if(type===System.Boolean)return raw!==0;else if(Bridge.Reflection.isEnum(type))return Bridge.unbox(System.Enum.parse(type,raw));else if(type===System.SByte)return raw|0;else if(type===System.Byte)return raw>>>0;else if(type===System.Int16)return raw|0;else if(type===System.UInt16)return raw>>>0;else if(type===System.Int32)return raw|0;else if(type===System.UInt32)return raw>>>0;else if(type===System.Int64)return System.Int64(raw);else if(type===System.UInt64)return System.UInt64(raw);else if(type===System.Single)return raw;else if(type===System.Double)return raw;else if(type===System.Decimal)return System.Decimal(raw);else if(type===System.Char)return raw|0;else if(type===System.String)return raw.toString();else if(type===System.DateTime)return System.DateTime.create$2(raw|0,0);else if(type===System.TimeSpan)return System.TimeSpan.fromTicks(raw);else if(type===System.DateTimeOffset)return new System.DateTimeOffset.$ctor5(System.Int64(raw|0),(new System.DateTimeOffset.ctor).Offset);else{if(castOperator=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(raw,type),castOperator)return castOperator(raw);if(isObject)return Bridge.box(raw,Bridge.getType(raw));throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(raw),Bridge.getTypeName(type)));}}else if(typeof raw=="string"){if(isDecimal=type===System.Decimal,isSpecial=isDecimal||System.Int64.is64BitType(type),isSpecial&&(isDecimal?!type.tryParse(raw,null,{}):!type.tryParse(raw,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Input string '{0}' is not a valid {1}",raw,Bridge.getTypeName(type)));if(isFloat=type==System.Double||type==System.Single,!isSpecial&&type.$number&&(isFloat?!type.tryParse(raw,null,{}):!type.tryParse(raw,{})))throw new Newtonsoft.Json.JsonException(System.String.format("Could not convert {0} to {1}: {2}",Bridge.getTypeName(raw),Bridge.getTypeName(type),raw));if(type===Function||type==System.Type)return Bridge.Reflection.getType(raw);else if(type===System.Globalization.CultureInfo)return new System.Globalization.CultureInfo(raw);else if(type===System.Uri)return new System.Uri(raw);else if(type===System.Guid)return System.Guid.Parse(raw);else if(type===System.Boolean)return(parsed={v:!1},!System.String.isNullOrWhiteSpace(raw)&&System.Boolean.tryParse(raw,parsed))?parsed.v:!1;else if(type===System.SByte)return raw|0;else if(type===System.Byte)return raw>>>0;else if(type===System.Int16)return raw|0;else if(type===System.UInt16)return raw>>>0;else if(type===System.Int32)return raw|0;else if(type===System.UInt32)return raw>>>0;else if(type===System.Int64)return System.Int64(raw);else if(type===System.UInt64)return System.UInt64(raw);else if(type===System.Single)return parseFloat(raw);else if(type===System.Double)return parseFloat(raw);else if(type===System.Decimal)try{return System.Decimal(raw)}catch(ex){return System.Decimal(0)}else if(type===System.Char)return raw.length===0?0:raw.charCodeAt(0);else if(type===System.String)return field?raw:JSON.parse(raw);else if(type===System.TimeSpan)return System.TimeSpan.parse(raw[0]=='"'?JSON.parse(raw):raw);else if(type===System.DateTime){var isUtc=System.String.endsWith(raw,"Z"),format="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+(isUtc?"'Z'":"K"),d=System.DateTime.parseExact(raw,format,null,!0,!0);return d=d!=null?d:System.DateTime.parse(raw,undefined,!0),isUtc&&d.kind!==1&&(d=System.DateTime.specifyKind(d,1)),d}else if(type===System.DateTimeOffset){var isUtc=System.String.endsWith(raw,"Z"),format="yyyy'-'MM'-'dd'T'HH':'mm':'ss.FFFFFFF"+(isUtc?"'Z'":"K"),d=System.DateTime.parseExact(raw,format,null,!0,!0);return d=d!=null?d:System.DateTime.parse(raw,undefined,!0),isUtc&&d.kind!==1&&(d=System.DateTime.specifyKind(d,1)),new System.DateTimeOffset.$ctor1(d)}else if(Bridge.Reflection.isEnum(type))return Bridge.unbox(System.Enum.parse(type,raw));else if(type===System.Array.type(System.Byte,1))return System.Convert.fromBase64String(raw);else{if(castOperator=Newtonsoft.Json.JsonConvert.tryToGetCastOperator(raw,type),castOperator)return castOperator(raw);if(isObject)return raw;throw new System.ArgumentException(System.String.format("Could not cast or convert from {0} to {1}",Bridge.getTypeName(raw),Bridge.getTypeName(type)));}}else if(typeof raw=="object")if(def!==null&&type.$kind!=="struct")return def;else if(Bridge.isArray(null,type)){if(typeName=raw.$type,typeName!=null&&(type=Newtonsoft.Json.JsonConvert.BindToType(settings,typeName,type),raw=raw.$values),raw.length===undefined)return[];for(arr=[],System.Array.type(type.$elementType,type.$rank||1,arr),i=0;i<raw.length;i++)arr[i]=Newtonsoft.Json.JsonConvert.DeserializeObject(raw[i],type.$elementType,settings,!0);return arr}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IList,type)){if(typeName=raw.$type,typeName!=null&&(type=Newtonsoft.Json.JsonConvert.BindToType(settings,typeName,type),raw=raw.$values),typeElement=System.Collections.Generic.List$1.getElementType(type)||System.Object,list=instance?{value:instance}:Newtonsoft.Json.JsonConvert.createInstance(type,raw,settings),list&&list.$list)return list.value;if(list=list.value,raw.length===undefined)return list;for(i=0;i<raw.length;i++)list.add(Newtonsoft.Json.JsonConvert.DeserializeObject(raw[i],typeElement,settings,!0));return list}else if(Bridge.Reflection.isAssignableFrom(System.Collections.IDictionary,type)){var typesGeneric=System.Collections.Generic.Dictionary$2.getTypeParameters(type),typeKey=typesGeneric[0]||System.Object,typeValue=typesGeneric[1]||System.Object,names,typeName=raw.$type,handling=!1;if(typeName!=null&&(type=Newtonsoft.Json.JsonConvert.BindToType(settings,typeName,type),handling=!0),dictionary=instance?{value:instance}:Newtonsoft.Json.JsonConvert.createInstance(type,raw,settings),dictionary&&dictionary.$list)return dictionary.value;names=dictionary.names||[];dictionary=dictionary.value;for(each in raw)raw.hasOwnProperty(each)&&(!handling||each!=="$type")&&names.indexOf(each)<0&&dictionary.add(Newtonsoft.Json.JsonConvert.DeserializeObject(each,typeKey,settings,!0),Newtonsoft.Json.JsonConvert.DeserializeObject(raw[each],typeValue,settings,!0));return dictionary}else{if(typeName=raw.$type,typeName!=null&&(type=Newtonsoft.Json.JsonConvert.BindToType(settings,typeName,type)),!Bridge.getMetadata(type))return Bridge.merge(isObject?{}:instance||Bridge.createInstance(type),raw);if(o=instance?{value:instance,names:i_names,"default":!0}:Newtonsoft.Json.JsonConvert.createInstance(type,raw,settings),names=o.names||[],isDefCtor=o.default,o=o.value,methods=Bridge.Reflection.getMembers(type,8,54),methods.length>0)for(midx=0;midx<methods.length;midx++)System.Attribute.isDefined(methods[midx],System.Runtime.Serialization.OnDeserializingAttribute,!1)&&Bridge.Reflection.midel(methods[midx],o)(null);for(camelCase=settings&&Bridge.is(settings.ContractResolver,Newtonsoft.Json.Serialization.CamelCasePropertyNamesContractResolver),fields=Newtonsoft.Json.JsonConvert.getMembers(type,4),i=0;i<fields.length;i++)(cfg=fields[i],f=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||(camelCase?f.n.charAt(0).toLowerCase()+f.n.substr(1):f.n),names.indexOf(mname)>-1)||(value=raw[mname],value===undefined&&(value=Newtonsoft.Json.JsonConvert.getValue(raw,mname)),result=Newtonsoft.Json.JsonConvert.preRawProcess(cfg,raw,value,settings),value=result.value,value!==undefined&&(currentValue=Bridge.Reflection.fieldAccess(f,o),objectCreationHandling=Newtonsoft.Json.ObjectCreationHandling.Auto,finst=undefined,cfg.attr&&cfg.attr._objectCreationHandling!=null?objectCreationHandling=cfg.attr._objectCreationHandling:settings._objectCreationHandling!=null&&(objectCreationHandling=settings._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(objectCreationHandling,currentValue,f.rt,isDefCtor)&&(finst=Bridge.unbox(currentValue,!0)),cfg.attr&&(typeNameHandling=cfg.attr._typeNameHandling),typeNameHandling!=null&&(oldTypeNameHandling=settings._typeNameHandling,settings._typeNameHandling=typeNameHandling),svalue=Newtonsoft.Json.JsonConvert.DeserializeObject(value,f.rt,settings,!0,finst),typeNameHandling!=null&&(settings._typeNameHandling=oldTypeNameHandling),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,o,svalue,settings),result!==!1&&finst===undefined&&Bridge.Reflection.fieldAccess(f,o,result.value)));for(properties=Newtonsoft.Json.JsonConvert.getMembers(type,16),i=0;i<properties.length;i++)(cfg=properties[i],p=cfg.member,mname=cfg.attr&&cfg.attr.PropertyName||(camelCase?p.n.charAt(0).toLowerCase()+p.n.substr(1):p.n),names.indexOf(mname)>-1)||(value=raw[mname],value===undefined&&(value=Newtonsoft.Json.JsonConvert.getValue(raw,mname)),result=Newtonsoft.Json.JsonConvert.preRawProcess(cfg,raw,value,settings),value=result.value,value!==undefined&&(finst=undefined,p.g&&(currentValue=Bridge.Reflection.midel(p.g,o)(),objectCreationHandling=Newtonsoft.Json.ObjectCreationHandling.Auto,cfg.attr&&cfg.attr._objectCreationHandling!=null?objectCreationHandling=cfg.attr._objectCreationHandling:settings._objectCreationHandling!=null&&(objectCreationHandling=settings._objectCreationHandling),Newtonsoft.Json.JsonConvert.needReuse(objectCreationHandling,currentValue,p.rt,isDefCtor)&&(finst=Bridge.unbox(currentValue,!0))),cfg.attr&&(typeNameHandling=cfg.attr._typeNameHandling),typeNameHandling!=null&&(oldTypeNameHandling=settings._typeNameHandling,settings._typeNameHandling=typeNameHandling),svalue=Newtonsoft.Json.JsonConvert.DeserializeObject(value,p.rt,settings,!0,finst),typeNameHandling!=null&&(settings._typeNameHandling=oldTypeNameHandling),result=Newtonsoft.Json.JsonConvert.preProcess(cfg,o,svalue,settings),result!==!1&&finst===undefined&&(p.s?Bridge.Reflection.midel(p.s,o)(result.value):type.$kind==="anonymous"&&(o[p.n]=result.value))));if(methods.length>0)for(midx=0;midx<methods.length;midx++)System.Attribute.isDefined(methods[midx],System.Runtime.Serialization.OnDeserializedAttribute,!1)&&Bridge.Reflection.midel(methods[midx],o)(null);return o}}}}});Newtonsoft.Json.$cache=[]});