"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[5067],{"./src/components/Text/Text.story.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{Basic:function(){return Basic},Example:function(){return Example},default:function(){return Text_story}});var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),StoryExample=__webpack_require__("./src/utils/storybook/StoryExample.tsx"),Stack=__webpack_require__("./src/components/Layout/Stack/Stack.tsx"),Text=__webpack_require__("./src/components/Text/Text.tsx"),lib=(__webpack_require__("../../node_modules/react/index.js"),__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@mdx-js/react/lib/index.js")),dist=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@storybook/blocks/dist/index.mjs"),TextLink=__webpack_require__("./src/components/Link/TextLink.tsx"),Tooltip=__webpack_require__("./src/components/Tooltip/Tooltip.tsx"),ExampleFrame=__webpack_require__("./src/utils/storybook/ExampleFrame.tsx");function _createMdxContent(props){const _components={a:"a",code:"code",em:"em",h1:"h1",h2:"h2",h3:"h3",hr:"hr",li:"li",ol:"ol",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,lib.R)(),...props.components};return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(dist.W8,{title:"MDX|Text",component:Text.E}),"\n",(0,jsx_runtime.jsx)(_components.h1,{id:"text",children:"Text"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"The Text component can be used to apply typography styles in a simple way, without the need of extra css."}),"\n",(0,jsx_runtime.jsx)(_components.hr,{}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"In this documentation you can find:"}),"\n",(0,jsx_runtime.jsxs)(_components.ol,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#usage",children:"Usage"})}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#content",children:"Content"})}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:[(0,jsx_runtime.jsx)(_components.a,{href:"#formating",children:"Formating"}),"\n",(0,jsx_runtime.jsxs)(_components.ol,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#anatomy",children:"Anatomy"})}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#behaviour",children:"Behaviour"})}),"\n"]}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#accessibility",children:"Accessibility"})}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:(0,jsx_runtime.jsx)(_components.a,{href:"#propstable",children:"Props table"})}),"\n"]}),"\n",(0,jsx_runtime.jsx)("br",{}),"\n",(0,jsx_runtime.jsx)("br",{}),"\n",(0,jsx_runtime.jsxs)(_components.h2,{id:"-usage",children:[(0,jsx_runtime.jsx)("a",{name:"usage"})," Usage"]}),"\n",(0,jsx_runtime.jsx)("br",{}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"when-to-use",children:(0,jsx_runtime.jsx)(_components.strong,{children:"When to use"})}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:"To display text, with styles applied consistently across the product, and to provide structure to each page."}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"when-not-to-use",children:(0,jsx_runtime.jsx)(_components.strong,{children:"When not to use"})}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:"If there is any straightforward interaction between the text and the user there should be a better component to use: Button, TextLink, Menu…"}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"dos",children:(0,jsx_runtime.jsx)(_components.strong,{children:"Do's"})}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:"Heading should be organized in hierarchy."}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["When a heading needs to have the appearance of another heading rank but it will affect the page heading hierarchy, use ",(0,jsx_runtime.jsx)(_components.code,{children:"variant"})," prop to modify its style instead."]}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:"Use weight or italic for emphasis."}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["Use the ",(0,jsx_runtime.jsx)(_components.code,{children:"tabular"})," prop when numbers should have a fixed width, such as in tables."]}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"donts",children:(0,jsx_runtime.jsx)(_components.strong,{children:"Don'ts"})}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsxs)(_components.li,{children:["\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Do not use the ",(0,jsx_runtime.jsx)(_components.code,{children:"element"})," prop because of its appearance, use it to organize the structure of the page."]}),"\n"]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Do not use color for emphasis as colors are related to states such as ",(0,jsx_runtime.jsx)(_components.code,{children:"error"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"success"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"disabled"})," and so on."]}),"\n"]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Do not use the ",(0,jsx_runtime.jsx)(_components.code,{children:"code"})," variant for anything other than code snippets."]}),"\n",(0,jsx_runtime.jsx)("br",{}),"\n",(0,jsx_runtime.jsx)("br",{}),"\n"]}),"\n"]}),"\n",(0,jsx_runtime.jsxs)(_components.h2,{id:"-content",children:[(0,jsx_runtime.jsx)("a",{name:"content"})," Content"]}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["The content of the text should be written according to the ",(0,jsx_runtime.jsx)(_components.a,{href:"https://grafana.com/docs/writers-toolkit/write/style-guide/",rel:"nofollow",children:"Grafana writing style guide"}),"."]}),"\n",(0,jsx_runtime.jsxs)(_components.h2,{id:"-formating",children:[(0,jsx_runtime.jsx)("a",{name:"formating"})," Formating"]}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"The following is the default behaviour and so, it will be applied according to its type."}),"\n",(0,jsx_runtime.jsxs)(_components.h3,{id:"anatomy",children:[(0,jsx_runtime.jsx)("a",{name:"anatomy"}),(0,jsx_runtime.jsx)(_components.strong,{children:"Anatomy"}),":",(0,jsx_runtime.jsx)("br",{})]}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"The Text component is mainly comprised by itself. In occasions, the Text component can have another Text or TextLink component as a child."}),"\n",(0,jsx_runtime.jsx)(ExampleFrame.s,{children:(0,jsx_runtime.jsxs)(Text.E,{color:"primary",element:"p",children:["If you need more help of how to write in Grafana you can go to our ",(0,jsx_runtime.jsx)(TextLink.Y,{href:"https://grafana.com/docs/writers-toolkit/",external:!0,children:"Writer’s Toolkit"})]})}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:'<Text color="primary" element="p">\n  If you need more help of how to write in Grafana you can go to our\n  <TextLink href="https://grafana.com/docs/writers-toolkit/" external>\n    Writer’s Toolkit\n  </TextLink>\n</Text>\n'})}),"\n",(0,jsx_runtime.jsx)(ExampleFrame.s,{children:(0,jsx_runtime.jsxs)(Text.E,{color:"primary",element:"p",children:["And Forrest Gump said: ",(0,jsx_runtime.jsx)(Text.E,{italic:!0,children:"Life is like a box of chocolates. You never know what you're gonna get."})]})}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:'<Text color="primary" element="p">\n  And Forrest Gump said:\n  <Text italic>Life is like a box of chocolates. You never know what you\'re gonna get.</Text>\n</Text>\n'})}),"\n",(0,jsx_runtime.jsxs)(_components.h3,{id:"behaviour",children:[(0,jsx_runtime.jsx)("a",{name:"behaviour"}),(0,jsx_runtime.jsx)(_components.strong,{children:"Behaviour"}),":"]}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["The Text component can be truncated. However, the Text component element rendered by default (no value set in element prop) is a ",(0,jsx_runtime.jsx)(_components.code,{children:"<span>"}),". As this is an inline container that must have a parent, which can be another Text component or not, the truncation must be applied to this parent element."]}),"\n",(0,jsx_runtime.jsxs)(_components.ol,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:"The parent element is a Text component: the user just has to set the element prop to another value and the truncate prop to true.\nAs a result, the Text will be truncated but when the user hovers over it the full text will be seen on a tooltip."}),"\n"]}),"\n",(0,jsx_runtime.jsx)(ExampleFrame.s,{children:(0,jsx_runtime.jsxs)(Text.E,{color:"primary",element:"p",truncate:!0,children:["And Forrest Gump said: ",(0,jsx_runtime.jsx)(Text.E,{italic:!0,children:"Life is like a box of chocolates. You never know what you are gonna get."})]})}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:'<Text color="primary" element="p" truncate>\n  And Forrest Gump said:\n  <Text italic>Life is like a box of chocolates. You never know what you are gonna get.</Text>\n</Text>\n'})}),"\n",(0,jsx_runtime.jsxs)(_components.ol,{start:"2",children:["\n",(0,jsx_runtime.jsxs)(_components.li,{children:["The parent element is not a Text component: the user has to add ",(0,jsx_runtime.jsx)(_components.code,{children:"overflow: hidden"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"text-overflow: ellipsis"})," and ",(0,jsx_runtime.jsx)(_components.code,{children:"whiteSpace: 'nowrap'"})," to it. In this case, the user should wrap up this container with a Tooltip, so when the text is truncated its content can still be seen hovering on the text."]}),"\n"]}),"\n",(0,jsx_runtime.jsx)(ExampleFrame.s,{children:(0,jsx_runtime.jsx)(Tooltip.m,{content:"This is a example of a span element truncated by its parent container",children:(0,jsx_runtime.jsx)("div",{style:{overflow:"hidden",textOverflow:"ellipsis",whiteSpace:"nowrap"},children:(0,jsx_runtime.jsx)(Text.E,{color:"primary",variant:"body",children:"This is a example of a span element truncated by its parent container."})})})}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:"<Tooltip content=\"This is a example of a span element truncated by its parent container\">\n  <div style={{ overflow: 'hidden', textOverflow: 'ellipsis', whiteSpace: 'nowrap' }}>\n    <Text color=\"primary\" variant=\"body\">\n      {'This is a example of a span element truncated by its parent container.'}\n    </Text>\n  </div>\n</Tooltip>\n"})}),"\n",(0,jsx_runtime.jsxs)(_components.h3,{id:"accessibility",children:[(0,jsx_runtime.jsx)("a",{name:"accessibility"}),(0,jsx_runtime.jsx)(_components.strong,{children:"Accessibility"}),":"]}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsxs)(_components.li,{children:["There should be just a ",(0,jsx_runtime.jsx)(_components.code,{children:"h1"})," heading per page."]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["The headings should be organized regarding its importance: ",(0,jsx_runtime.jsx)(_components.code,{children:"h1"})," has the ",(0,jsx_runtime.jsx)(_components.em,{children:"rank 1"})," while ",(0,jsx_runtime.jsx)(_components.code,{children:"h6"})," heading has the ",(0,jsx_runtime.jsx)(_components.em,{children:"rank 6"}),". For example, ",(0,jsx_runtime.jsx)(_components.code,{children:"h1"})," can be used in the page heading, ",(0,jsx_runtime.jsx)(_components.code,{children:"h2"})," for the titles of the sections and ",(0,jsx_runtime.jsx)(_components.code,{children:"h3"})," for the subsections."]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:["The ranking of headings should be continuous. An ",(0,jsx_runtime.jsx)(_components.code,{children:"h2"})," should not be followed by an ",(0,jsx_runtime.jsx)(_components.code,{children:"h5"})," but an ",(0,jsx_runtime.jsx)(_components.code,{children:"h2"})," can follow an ",(0,jsx_runtime.jsx)(_components.code,{children:"h5"})," if this is closing the previous section. Skipping heading ranks should be avoided where possible as it can be confusing."]}),"\n"]}),"\n",(0,jsx_runtime.jsxs)(_components.h2,{id:"props-table",children:[(0,jsx_runtime.jsx)("a",{name:"propstable"}),"Props table"]}),"\n",(0,jsx_runtime.jsx)(dist.ov,{of:Text.E})]})}const meta={title:"Foundations/Text",component:Text.E,parameters:{docs:{page:function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent(props)}}},argTypes:{variant:{control:"select",options:["h1","h2","h3","h4","h5","h6","body","bodySmall","code",void 0]},weight:{control:"select",options:["bold","medium","light","regular",void 0]},color:{control:"select",options:["error","success","warning","info","primary","secondary","disabled","link","maxContrast",void 0]},truncate:{control:"boolean"},italic:{control:"boolean"},tabular:{control:"boolean"},textAlignment:{control:"select",options:["inherit","initial","left","right","center","justify",void 0]}},args:{element:"h1",variant:void 0,weight:"light",textAlignment:"left",truncate:!1,italic:!1,color:"primary",children:"This is an example of a Text component"}},Example=args=>(0,jsx_runtime.jsxs)(Stack.B,{direction:"column",children:[(0,jsx_runtime.jsxs)(StoryExample.Q,{name:"Header, paragraph and span",children:[(0,jsx_runtime.jsx)(Text.E,{...args,element:"h1",children:"This is a header"}),(0,jsx_runtime.jsxs)(Text.E,{...args,element:"p",children:["This is a paragraph that contains",(0,jsx_runtime.jsxs)(Text.E,{color:"success",italic:!0,children:[" ","a span element with different color and style"," "]}),"but is comprised within the same block text"]})]}),(0,jsx_runtime.jsx)(StoryExample.Q,{name:"Paragraph with truncate set to true and wrapping up a span element",children:(0,jsx_runtime.jsxs)(Text.E,{...args,element:"p",truncate:!0,children:["This is a paragraph that contains",(0,jsx_runtime.jsxs)(Text.E,{color:"warning",italic:!0,children:[" ","a span element"," "]}),"but has truncate set to true"]})})]});Example.parameters={controls:{exclude:["element","variant","weight","textAlignment","truncate","italic","tabular","color","children"]}};const Basic=args=>(0,jsx_runtime.jsx)("div",{style:{width:"300px"},children:(0,jsx_runtime.jsx)(Text.E,{element:args.element,variant:args.variant,weight:args.weight,textAlignment:args.textAlignment,...args,children:args.children})});var Text_story=meta;Example.parameters={...Example.parameters,docs:{...Example.parameters?.docs,source:{originalSource:'args => {\n  return <Stack direction="column">\n      <StoryExample name="Header, paragraph and span">\n        <Text {...args} element="h1">\n          This is a header\n        </Text>\n        <Text {...args} element="p">\n          This is a paragraph that contains\n          <Text color="success" italic>\n            {\' \'}\n            a span element with different color and style{\' \'}\n          </Text>\n          but is comprised within the same block text\n        </Text>\n      </StoryExample>\n      <StoryExample name="Paragraph with truncate set to true and wrapping up a span element">\n        <Text {...args} element="p" truncate>\n          This is a paragraph that contains\n          <Text color="warning" italic>\n            {\' \'}\n            a span element{\' \'}\n          </Text>\n          but has truncate set to true\n        </Text>\n      </StoryExample>\n    </Stack>;\n}',...Example.parameters?.docs?.source}}},Basic.parameters={...Basic.parameters,docs:{...Basic.parameters?.docs,source:{originalSource:"args => {\n  return <div style={{\n    width: '300px'\n  }}>\n      <Text element={args.element} variant={args.variant} weight={args.weight} textAlignment={args.textAlignment} {...args}>\n        {args.children}\n      </Text>\n    </div>;\n}",...Basic.parameters?.docs?.source}}}}}]);