import { RefCallback } from 'react';
import * as React from 'react';
import { SelectableValue } from '@grafana/data';
import { ToggleAllState } from './types';
export interface ToggleAllOptions {
    state: ToggleAllState;
    selectAllClicked: () => void;
    selectedCount?: number;
}
interface SelectMenuProps {
    maxHeight: number;
    innerRef: RefCallback<HTMLDivElement>;
    innerProps: {};
    selectProps: {
        toggleAllOptions?: ToggleAllOptions;
        components?: {
            Option?: (props: React.PropsWithChildren<SelectMenuOptionProps<unknown>>) => JSX.Element;
        };
    };
}
export declare const SelectMenu: {
    ({ children, maxHeight, innerRef, innerProps, selectProps, }: React.PropsWithChildren<SelectMenuProps>): import("react/jsx-runtime").JSX.Element;
    displayName: string;
};
interface VirtualSelectMenuProps<T> {
    children: React.ReactNode;
    innerRef: React.Ref<HTMLDivElement>;
    focusedOption: T;
    innerProps: JSX.IntrinsicElements['div'];
    options: T[];
    maxHeight: number;
    selectProps: {
        toggleAllOptions?: ToggleAllOptions;
        components?: {
            Option?: (props: React.PropsWithChildren<SelectMenuOptionProps<unknown>>) => JSX.Element;
        };
    };
}
export declare const VirtualizedSelectMenu: {
    ({ children, maxHeight, innerRef: scrollRef, options, selectProps, focusedOption, }: VirtualSelectMenuProps<SelectableValue>): import("react/jsx-runtime").JSX.Element | null;
    displayName: string;
};
interface SelectMenuOptionProps<T> {
    isDisabled: boolean;
    isFocused: boolean;
    isSelected: boolean;
    indeterminate?: boolean;
    innerProps: JSX.IntrinsicElements['div'];
    innerRef: RefCallback<HTMLDivElement>;
    renderOptionLabel?: (value: SelectableValue<T>) => JSX.Element;
    data: SelectableValue<T>;
}
export declare const SelectMenuOptions: {
    ({ children, data, innerProps, innerRef, isFocused, isSelected, renderOptionLabel, }: React.PropsWithChildren<SelectMenuOptionProps<unknown>>): import("react/jsx-runtime").JSX.Element;
    displayName: string;
};
export {};
