import React from 'react';
export interface ElementSelectionOnSelectOptions {
    /** If specified, this will ignore the shift key press */
    multi?: boolean;
    /** If true, this will make sure the element is selected */
    force?: boolean;
}
/** @alpha */
export interface ElementSelectionContextState {
    /**
     * Turn on selection mode & show selection state
     */
    enabled?: boolean;
    /** List of currently selected elements */
    selected: ElementSelectionContextItem[];
    onSelect: (item: ElementSelectionContextItem, options: ElementSelectionOnSelectOptions) => void;
    onClear: () => void;
}
export interface ElementSelectionContextItem {
    id: string;
}
export declare const ElementSelectionContext: React.Context<ElementSelectionContextState | undefined>;
export interface UseElementSelectionResult {
    isSelected?: boolean;
    isSelectable?: boolean;
    onSelect?: (evt: React.MouseEvent, options?: ElementSelectionOnSelectOptions) => void;
    onClear?: () => void;
}
export declare function useElementSelection(id: string | undefined): UseElementSelectionResult;
