import { PickerProps } from 'rc-picker';
import { DateTime } from '@grafana/data';
import { FormInputSize } from '../Forms/types';
import 'rc-picker/assets/index.css';
interface BaseProps {
    onChange: (value: DateTime) => void | ((value?: DateTime) => void);
    value?: DateTime;
    showHour?: boolean;
    showSeconds?: boolean;
    minuteStep?: PickerProps['minuteStep'];
    size?: FormInputSize;
    disabled?: boolean;
    disabledHours?: () => number[];
    disabledMinutes?: () => number[];
    disabledSeconds?: () => number[];
    placeholder?: string;
    allowEmpty?: boolean;
}
interface AllowEmptyProps extends BaseProps {
    allowEmpty: true;
    onChange: (value?: DateTime) => void;
}
interface NoAllowEmptyProps extends BaseProps {
    allowEmpty?: false;
    onChange: (value: DateTime) => void;
}
export type Props = AllowEmptyProps | NoAllowEmptyProps;
export declare const POPUP_CLASS_NAME = "time-of-day-picker-panel";
export declare const TimeOfDayPicker: ({ minuteStep, showHour, showSeconds, value, size, disabled, disabledHours, disabledMinutes, disabledSeconds, placeholder, ...restProps }: Props) => import("react/jsx-runtime").JSX.Element;
export {};
