import 'tinycolor2';

function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}

export { getFocusStyles, getMouseFocusStyles, mediaUp };
//# sourceMappingURL=mixins.mjs.map
