import { jsx } from 'react/jsx-runtime';
import { Global } from '@emotion/react';
import { useTheme2 } from '../ThemeContext.mjs';
import { getAccessibilityStyles } from './accessibility.mjs';
import { getAlertingStyles } from './alerting.mjs';
import { getCardStyles } from './card.mjs';
import { getCodeStyles } from './code.mjs';
import { getDashboardGridStyles } from './dashboardGrid.mjs';
import { getDashDiffStyles } from './dashdiff.mjs';
import { getElementStyles } from './elements.mjs';
import { getExtraStyles } from './extra.mjs';
import { getFilterTableStyles } from './filterTable.mjs';
import { getFontStyles } from './fonts.mjs';
import { getFormElementStyles } from './forms.mjs';
import { getHacksStyles } from './hacks.mjs';
import { getJsonFormatterStyles } from './jsonFormatter.mjs';
import { getLegacySelectStyles } from './legacySelect.mjs';
import { getMarkdownStyles } from './markdownStyles.mjs';
import { getPageStyles } from './page.mjs';
import { getQueryEditorStyles } from './queryEditor.mjs';
import { getSkeletonStyles } from './skeletonStyles.mjs';
import { getSlateStyles } from './slate.mjs';
import { getUplotStyles } from './uPlot.mjs';
import { getUtilityClassStyles } from './utilityClasses.mjs';

function GlobalStyles(props) {
  const theme = useTheme2();
  const { isExtensionSidebarOpen } = props;
  return /* @__PURE__ */ jsx(
    Global,
    {
      styles: [
        getAccessibilityStyles(),
        getAlertingStyles(theme),
        getCodeStyles(theme),
        getDashDiffStyles(theme),
        getDashboardGridStyles(theme),
        getElementStyles(theme, isExtensionSidebarOpen),
        getExtraStyles(theme),
        getFilterTableStyles(theme),
        getFontStyles(),
        getFormElementStyles(theme),
        getJsonFormatterStyles(theme),
        getCardStyles(theme),
        getMarkdownStyles(theme),
        getPageStyles(theme),
        getQueryEditorStyles(theme),
        getSkeletonStyles(),
        getSlateStyles(theme),
        getUplotStyles(),
        getUtilityClassStyles(theme),
        getLegacySelectStyles(theme),
        getHacksStyles()
      ]
    }
  );
}

export { GlobalStyles };
//# sourceMappingURL=GlobalStyles.mjs.map
