import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { getValueFromDimension, dateTimeFormat } from '@grafana/data';
import { ContextMenu } from '../../components/ContextMenu/ContextMenu.mjs';
import { FormattedValueDisplay } from '../../components/FormattedValueDisplay/FormattedValueDisplay.mjs';
import { HorizontalGroup } from '../../components/Layout/Layout.mjs';
import { MenuGroup } from '../../components/Menu/MenuGroup.mjs';
import { MenuItem } from '../../components/Menu/MenuItem.mjs';
import { SeriesIcon } from '../../components/VizLegend/SeriesIcon.mjs';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const GraphContextMenu = ({
  getContextMenuSource,
  timeZone,
  itemsGroup,
  dimensions,
  contextDimensions,
  ...otherProps
}) => {
  const source = getContextMenuSource();
  const itemsToRender = itemsGroup ? itemsGroup.map((group) => {
    var _a;
    return {
      ...group,
      items: (_a = group.items) == null ? void 0 : _a.filter((item) => item.label)
    };
  }) : [];
  const renderHeader = () => {
    var _a;
    if (!source) {
      return null;
    }
    let value;
    if ((dimensions == null ? void 0 : dimensions.yAxis) && ((_a = contextDimensions == null ? void 0 : contextDimensions.yAxis) == null ? void 0 : _a[1])) {
      const valueFromDimensions = getValueFromDimension(
        dimensions.yAxis,
        contextDimensions.yAxis[0],
        contextDimensions.yAxis[1]
      );
      const display = source.series.valueField.display;
      value = display(valueFromDimensions);
    }
    const formattedValue = dateTimeFormat(source.datapoint[0], {
      defaultWithMS: source.series.hasMsResolution,
      timeZone
    });
    return /* @__PURE__ */ jsx(
      GraphContextMenuHeader,
      {
        timestamp: formattedValue,
        seriesColor: source.series.color,
        displayName: source.series.alias || source.series.label,
        displayValue: value
      }
    );
  };
  const renderMenuGroupItems = () => {
    return itemsToRender == null ? void 0 : itemsToRender.map((group, index) => /* @__PURE__ */ jsx(MenuGroup, { label: group.label, children: (group.items || []).map((item) => /* @__PURE__ */ jsx(
      MenuItem,
      {
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick
      },
      `${item.label}`
    )) }, `${group.label}${index}`));
  };
  return /* @__PURE__ */ jsx(ContextMenu, { ...otherProps, renderMenuItems: renderMenuGroupItems, renderHeader });
};
const GraphContextMenuHeader = ({
  timestamp,
  seriesColor,
  displayName,
  displayValue
}) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsx("strong", { children: timestamp }),
    /* @__PURE__ */ jsxs(HorizontalGroup, { children: [
      /* @__PURE__ */ jsxs("div", { children: [
        /* @__PURE__ */ jsx(SeriesIcon, { color: seriesColor }),
        /* @__PURE__ */ jsx("span", { className: styles.displayName, children: displayName })
      ] }),
      displayValue && /* @__PURE__ */ jsx(FormattedValueDisplay, { value: displayValue })
    ] })
  ] });
};
function getStyles(theme) {
  return {
    wrapper: css({
      padding: theme.spacing(0.5, 1),
      fontSize: theme.typography.size.sm,
      zIndex: theme.zIndex.tooltip
    }),
    displayName: css({
      whiteSpace: "nowrap",
      paddingLeft: theme.spacing(0.5)
    })
  };
}

export { GraphContextMenu, GraphContextMenuHeader };
//# sourceMappingURL=GraphContextMenu.mjs.map
