import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import * as React from 'react';
import { useRef } from 'react';
import { CSSTransition } from 'react-transition-group';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles, duration, horizontal ? "width" : "height", size);
  const transitionRef = useRef(null);
  return /* @__PURE__ */ jsx(
    CSSTransition,
    {
      in: visible,
      mountOnEnter: true,
      unmountOnExit: true,
      timeout: duration,
      classNames: styles,
      nodeRef: transitionRef,
      children: React.cloneElement(children, { ref: transitionRef })
    }
  );
}
const getStyles = (theme, duration, measurement, size) => ({
  enter: css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  }),
  exit: css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    [theme.transitions.handleMotion("no-preference")]: {
      transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
    },
    [theme.transitions.handleMotion("reduce")]: {
      transition: `opacity ${duration}ms ease-out`
    }
  })
});

export { SlideOutTransition };
//# sourceMappingURL=SlideOutTransition.mjs.map
