import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const VizTooltipWrapper = ({ children, className }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(styles.wrapper, className), children });
};
const getStyles = (theme) => ({
  wrapper: css({
    display: "flex",
    flexDirection: "column",
    fontSize: theme.typography.bodySmall.fontSize
  })
});

export { VizTooltipWrapper };
//# sourceMappingURL=VizTooltipWrapper.mjs.map
