import { formattedValueToString } from '@grafana/data';
import { getDisplayName } from '../utils.mjs';

function calculateUniqueFieldValues(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const row = rows[index];
    const fieldValue = row[getDisplayName(field)];
    const displayValue = field.display ? field.display(fieldValue) : fieldValue;
    const value = field.display ? formattedValueToString(displayValue) : displayValue;
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function getFilteredOptions(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function valuesToOptions(unique) {
  return Object.keys(unique).map((key) => ({ value: unique[key], label: key })).sort(sortOptions);
}
function sortOptions(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}

export { calculateUniqueFieldValues, getFilteredOptions, valuesToOptions };
//# sourceMappingURL=utils.mjs.map
