import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { Icon } from '../../../Icon/Icon.mjs';

function RowExpander({ height, onCellExpand, isExpanded }) {
  const styles = useStyles2(getStyles, height);
  function handleKeyDown(e) {
    if (e.key === " " || e.key === "Enter") {
      e.preventDefault();
      onCellExpand(e);
    }
  }
  return /* @__PURE__ */ jsx("div", { role: "button", tabIndex: 0, className: styles.expanderCell, onClick: onCellExpand, onKeyDown: handleKeyDown, children: /* @__PURE__ */ jsx(
    Icon,
    {
      "aria-label": isExpanded ? t("grafana-ui.row-expander-ng.aria-label-collapse", "Collapse row") : t("grafana-ui.row-expander.aria-label-expand", "Expand row"),
      name: isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ) });
}
const getStyles = (theme, rowHeight) => ({
  expanderCell: css({
    display: "flex",
    flexDirection: "column",
    justifyContent: "center",
    height: `${rowHeight}px`,
    cursor: "pointer"
  })
});

export { RowExpander };
//# sourceMappingURL=RowExpander.mjs.map
