import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useEffect } from 'react';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { getFieldTypeIcon } from '../../../../types/icon.mjs';
import { Icon } from '../../../Icon/Icon.mjs';
import { Filter } from '../Filter/Filter.mjs';
import { getDisplayName } from '../utils.mjs';

const HeaderCell = ({
  column,
  rows,
  field,
  direction,
  filter,
  setFilter,
  crossFilterOrder,
  crossFilterRows,
  showTypeIcons
}) => {
  var _a, _b, _c, _d;
  const headerCellWrap = (_b = (_a = field.config.custom) == null ? void 0 : _a.wrapHeaderText) != null ? _b : false;
  const styles = useStyles2(getStyles, headerCellWrap);
  const displayName = getDisplayName(field);
  const filterable = (_d = (_c = field.config.custom) == null ? void 0 : _c.filterable) != null ? _d : false;
  useEffect(() => {
    if (!filterable && filter[displayName]) {
      setFilter((filter2) => {
        const newFilter = { ...filter2 };
        delete newFilter[displayName];
        return newFilter;
      });
    }
  }, [filterable, displayName, filter, setFilter]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    showTypeIcons && /* @__PURE__ */ jsx(Icon, { className: styles.headerCellIcon, name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm" }),
    /* @__PURE__ */ jsx("span", { className: styles.headerCellLabel, children: getDisplayName(field) }),
    direction && /* @__PURE__ */ jsx(
      Icon,
      {
        className: cx(styles.headerCellIcon, styles.headerSortIcon),
        size: "lg",
        name: direction === "ASC" ? "arrow-up" : "arrow-down"
      }
    ),
    filterable && /* @__PURE__ */ jsx(
      Filter,
      {
        name: column.key,
        rows,
        filter,
        setFilter,
        field,
        crossFilterOrder,
        crossFilterRows,
        iconClassName: styles.headerCellIcon
      }
    )
  ] });
};
const getStyles = (theme, headerTextWrap) => ({
  headerCellLabel: css({
    cursor: "pointer",
    fontWeight: theme.typography.fontWeightMedium,
    color: theme.colors.text.secondary,
    overflow: "hidden",
    textOverflow: "ellipsis",
    whiteSpace: headerTextWrap ? "pre-line" : "nowrap",
    "&:hover": {
      textDecoration: "underline",
      color: theme.colors.text.link
    }
  }),
  headerCellIcon: css({
    marginBottom: theme.spacing(0.5),
    alignSelf: "flex-end",
    color: theme.colors.text.secondary
  }),
  headerSortIcon: css({
    marginBottom: theme.spacing(0.25)
  })
});

export { HeaderCell };
//# sourceMappingURL=HeaderCell.mjs.map
