import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo } from 'react';
import { useStyles2 } from '../../../../themes/ThemeContext.mjs';
import { ActionButton } from '../../../Actions/ActionButton.mjs';

const ActionsCell = ({ field, rowIdx, getActions }) => {
  const styles = useStyles2(getStyles);
  const actions = useMemo(() => getActions(field, rowIdx), [getActions, field, rowIdx]);
  return /* @__PURE__ */ jsx("div", { className: styles.buttonsGap, children: actions.map((action, i) => /* @__PURE__ */ jsx(ActionButton, { action, variant: "secondary" }, i)) });
};
const getStyles = (theme) => ({
  buttonsGap: css({
    display: "flex",
    gap: 6
  })
});

export { ActionsCell };
//# sourceMappingURL=ActionsCell.mjs.map
