import { jsx, jsxs } from 'react/jsx-runtime';
import { isString } from 'lodash';
import { useState } from 'react';
import { t, Trans } from '@grafana/i18n';
import { ClipboardButton } from '../ClipboardButton/ClipboardButton.mjs';
import { Drawer } from '../Drawer/Drawer.mjs';
import { Stack } from '../Layout/Stack/Stack.mjs';
import { CodeEditor } from '../Monaco/CodeEditor.mjs';
import { Tab } from '../Tabs/Tab.mjs';
import { TabsBar } from '../Tabs/TabsBar.mjs';

var TableCellInspectorMode = /* @__PURE__ */ ((TableCellInspectorMode2) => {
  TableCellInspectorMode2["code"] = "code";
  TableCellInspectorMode2["text"] = "text";
  return TableCellInspectorMode2;
})(TableCellInspectorMode || {});
function TableCellInspector({ value, onDismiss, mode }) {
  let displayValue = value;
  const [currentMode, setMode] = useState(mode);
  if (isString(value)) {
    const trimmedValue = value.trim();
    if (trimmedValue[0] === "{" || trimmedValue[0] === "[" || mode === "code") {
      try {
        value = JSON.parse(value);
        displayValue = JSON.stringify(value, null, "  ");
      } catch (error) {
        console.log(
          "Failed to parse JSON in Table cell inspector (this will cause JSON to not print nicely): ",
          error.message
        );
      }
    }
  } else {
    displayValue = JSON.stringify(value);
  }
  let text = displayValue;
  const tabs = [
    {
      label: "Plain text",
      value: "text"
    },
    {
      label: "Code editor",
      value: "code"
    }
  ];
  const changeTabs = () => {
    setMode(currentMode === "text" /* text */ ? "code" /* code */ : "text" /* text */);
  };
  const tabBar = /* @__PURE__ */ jsx(TabsBar, { children: tabs.map((t2, index) => /* @__PURE__ */ jsx(Tab, { label: t2.label, active: t2.value === currentMode, onChangeTab: changeTabs }, `${t2.value}-${index}`)) });
  return /* @__PURE__ */ jsx(Drawer, { onClose: onDismiss, title: t("grafana-ui.table.inspect-drawer-title", "Inspect value"), tabs: tabBar, children: /* @__PURE__ */ jsxs(Stack, { direction: "column", gap: 2, children: [
    /* @__PURE__ */ jsx(ClipboardButton, { icon: "copy", getText: () => text, style: { marginLeft: "auto", width: "200px" }, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.table.copy", children: "Copy to Clipboard" }) }),
    currentMode === "code" ? /* @__PURE__ */ jsx(
      CodeEditor,
      {
        width: "100%",
        height: 500,
        language: "json",
        showLineNumbers: true,
        showMiniMap: (text && text.length) > 100,
        value: text,
        readOnly: true,
        wordWrap: true
      }
    ) : /* @__PURE__ */ jsx("pre", { children: text })
  ] }) });
}

export { TableCellInspector, TableCellInspectorMode };
//# sourceMappingURL=TableCellInspector.mjs.map
