import { jsx, jsxs } from 'react/jsx-runtime';
import * as React from 'react';
import { useState } from 'react';
import { formattedValueToString } from '@grafana/data';
import { TableCellDisplayMode } from '@grafana/schema';
import { getCellLinks } from '../../../utils/table.mjs';
import { CellActions } from '../CellActions.mjs';
import { renderSingleLink, DataLinksActionsTooltip } from '../DataLinksActionsTooltip.mjs';
import { TableCellInspectorMode } from '../TableCellInspector.mjs';
import { getCellOptions, getDataLinksActionsTooltipUtils, tooltipOnClickHandler, getCellColors } from '../utils.mjs';

const DefaultCell = (props) => {
  var _a, _b;
  const { field, cell, tableStyles, row, cellProps, frame, rowStyled, rowExpanded, textWrapped, height } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const displayValue = field.display(cell.value);
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== void 0 || inspectEnabled;
  const cellOptions = getCellOptions(field);
  let value;
  const OG_TWEET_LENGTH = 140;
  if (cellOptions.type === TableCellDisplayMode.Custom) {
    const CustomCellComponent = cellOptions.cellComponent;
    value = /* @__PURE__ */ jsx(CustomCellComponent, { field, value: cell.value, rowIndex: row.index, frame });
  } else {
    if (React.isValidElement(cell.value)) {
      value = cell.value;
    } else {
      value = formattedValueToString(displayValue);
    }
  }
  const isStringValue = typeof value === "string";
  const textShouldWrap = displayValue.text.length <= OG_TWEET_LENGTH && /\s/.test(displayValue.text);
  const cellStyle = getCellStyle(
    tableStyles,
    cellOptions,
    displayValue,
    inspectEnabled,
    isStringValue,
    textShouldWrap,
    textWrapped,
    rowStyled,
    rowExpanded
  );
  if (isStringValue) {
    let justifyContent = (_b = cellProps.style) == null ? void 0 : _b.justifyContent;
    if (justifyContent === "flex-end") {
      cellProps.style = { ...cellProps.style, textAlign: "right" };
    } else if (justifyContent === "center") {
      cellProps.style = { ...cellProps.style, textAlign: "center" };
    }
  }
  if (height) {
    cellProps.style = { ...cellProps.style, height };
  }
  if (textWrapped) {
    cellProps.style = { ...cellProps.style, textWrap: "wrap" };
  }
  const { key, ...rest } = cellProps;
  const links = getCellLinks(field, row) || [];
  const [tooltipCoords, setTooltipCoords] = useState();
  const { shouldShowLink, hasMultipleLinksOrActions } = getDataLinksActionsTooltipUtils(links);
  const shouldShowTooltip = hasMultipleLinksOrActions && tooltipCoords !== void 0;
  return (
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
    /* @__PURE__ */ jsxs(
      "div",
      {
        ...rest,
        className: cellStyle,
        style: { ...cellProps.style, cursor: hasMultipleLinksOrActions ? "context-menu" : "auto" },
        onClick: tooltipOnClickHandler(setTooltipCoords),
        children: [
          shouldShowLink ? renderSingleLink(links[0], value, getLinkStyle(tableStyles, cellOptions)) : shouldShowTooltip ? /* @__PURE__ */ jsx(
            DataLinksActionsTooltip,
            {
              links,
              value,
              coords: tooltipCoords,
              onTooltipClose: () => setTooltipCoords(void 0)
            }
          ) : isStringValue ? `${value}` : /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, children: value }),
          showActions && /* @__PURE__ */ jsx(CellActions, { ...props, previewMode: TableCellInspectorMode.text, showFilters })
        ]
      },
      key
    )
  );
};
const getLinkStyle = (tableStyles, cellOptions) => {
  if (cellOptions.type === TableCellDisplayMode.Auto) {
    return tableStyles.cellLink;
  }
  return tableStyles.cellLinkForColoredCell;
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false, isStringValue = false, shouldWrapText = false, textWrapped = false, rowStyled = false, rowExpanded = false) {
  let textColor = void 0;
  let bgColor = void 0;
  let bgHoverColor = void 0;
  const colors = getCellColors(tableStyles.theme, cellOptions, displayValue);
  textColor = colors.textColor;
  bgColor = colors.bgColor;
  bgHoverColor = colors.bgHoverColor;
  return tableStyles.buildCellContainerStyle(
    textColor,
    bgColor,
    bgHoverColor,
    !disableOverflowOnHover,
    isStringValue,
    shouldWrapText,
    textWrapped,
    rowStyled,
    rowExpanded
  );
}

export { DefaultCell };
//# sourceMappingURL=DefaultCell.mjs.map
