import { jsx } from 'react/jsx-runtime';
import { Icon } from '../Icon/Icon.mjs';
import { Spinner } from '../Spinner/Spinner.mjs';

function DropdownIndicator({ selectProps }) {
  const isOpen = selectProps.menuIsOpen;
  const icon = isOpen ? "search" : "angle-down";
  const size = "md";
  if (selectProps.isLoading) {
    return /* @__PURE__ */ jsx(Spinner, { inline: true });
  }
  return /* @__PURE__ */ jsx(Icon, { name: icon, size });
}

export { DropdownIndicator };
//# sourceMappingURL=DropdownIndicator.mjs.map
