import { jsx } from 'react/jsx-runtime';
import '@emotion/css';
import * as React from 'react';
import { useRef, useLayoutEffect } from 'react';
import ReactDOM from 'react-dom';
import '@grafana/e2e-selectors';
import { useTheme2 } from '../../themes/ThemeContext.mjs';

function Portal(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM.createPortal(/* @__PURE__ */ jsx("div", { ref: forwardedRef, children }), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
const RefForwardingPortal = React.forwardRef((props, ref) => {
  return /* @__PURE__ */ jsx(Portal, { ...props, forwardedRef: ref });
});
RefForwardingPortal.displayName = "RefForwardingPortal";

export { Portal, RefForwardingPortal, getPortalContainer };
//# sourceMappingURL=Portal.mjs.map
