import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import { useRef, useImperativeHandle } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Box } from '../Layout/Box/Box.mjs';
import { MenuDivider } from './MenuDivider.mjs';
import { MenuGroup } from './MenuGroup.mjs';
import { MenuItem } from './MenuItem.mjs';
import { useMenuFocus } from './hooks.mjs';

const MenuComp = React.forwardRef(
  ({ header, children, ariaLabel, onOpen, onClose, onKeyDown, ...otherProps }, forwardedRef) => {
    const styles = useStyles2(getStyles);
    const localRef = useRef(null);
    useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ isMenuOpen: true, localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ jsxs(
      Box,
      {
        ...otherProps,
        "aria-label": ariaLabel,
        backgroundColor: "elevated",
        borderRadius: "default",
        boxShadow: "z3",
        display: "inline-block",
        onKeyDown: handleKeys,
        paddingX: 0.5,
        paddingY: 0.5,
        ref: localRef,
        role: "menu",
        tabIndex: -1,
        children: [
          header && /* @__PURE__ */ jsx(
            "div",
            {
              className: cx(
                styles.header,
                Boolean(children) && React.Children.toArray(children).length > 0 && styles.headerBorder
              ),
              children: header
            }
          ),
          children
        ]
      }
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles = (theme) => {
  return {
    header: css({
      padding: theme.spacing(0.5, 0.5, 1, 0.5)
    }),
    headerBorder: css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      marginBottom: theme.spacing(0.5)
    })
  };
};

export { Menu };
//# sourceMappingURL=Menu.mjs.map
