import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const InlineFieldRow = ({ children, className, ...htmlProps }) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(styles.container, className), ...htmlProps, children });
};
const getStyles = (theme) => {
  return {
    container: css({
      label: "InlineFieldRow",
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      alignContent: "flex-start",
      rowGap: theme.spacing(0.5)
    })
  };
};

export { InlineFieldRow };
//# sourceMappingURL=InlineFieldRow.mjs.map
