import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { clearButtonStyles } from '../Button/Button.mjs';
import { Icon } from '../Icon/Icon.mjs';

const FilterPill = ({ label, selected, onClick, icon = "check" }) => {
  const styles = useStyles2(getStyles);
  const clearButton = useStyles2(clearButtonStyles);
  return /* @__PURE__ */ jsxs("button", { type: "button", className: cx(clearButton, styles.wrapper, selected && styles.selected), onClick, children: [
    /* @__PURE__ */ jsx("span", { children: label }),
    selected && /* @__PURE__ */ jsx(Icon, { name: icon, className: styles.icon, "data-testid": "filter-pill-icon" })
  ] });
};
const getStyles = (theme) => {
  return {
    wrapper: css({
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.pill,
      padding: theme.spacing(0, 2),
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      lineHeight: theme.typography.bodySmall.lineHeight,
      color: theme.colors.text.secondary,
      display: "flex",
      alignItems: "center",
      height: "32px",
      position: "relative",
      border: `1px solid ${theme.colors.background.secondary}`,
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary
      }
    }),
    selected: css({
      color: theme.colors.text.primary,
      background: theme.colors.action.selected,
      "&:hover": {
        background: theme.colors.action.focus
      }
    }),
    icon: css({
      marginLeft: theme.spacing(0.5)
    })
  };
};

export { FilterPill };
//# sourceMappingURL=FilterPill.mjs.map
