import { jsx } from 'react/jsx-runtime';
import { useMemo, useCallback } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { t } from '@grafana/i18n';
import { Combobox } from '../Combobox/Combobox.mjs';

function isWeekStart(value) {
  return ["saturday", "sunday", "monday"].includes(value);
}
function getWeekStart(override) {
  var _a, _b;
  if (override && isWeekStart(override)) {
    return override;
  }
  const preference = (_b = (_a = window == null ? void 0 : window.grafanaBootData) == null ? void 0 : _a.user) == null ? void 0 : _b.weekStart;
  if (preference && isWeekStart(preference)) {
    return preference;
  }
  return "monday";
}
const WeekStartPicker = (props) => {
  const { onChange, width, autoFocus = false, onBlur, value, disabled = false, inputId } = props;
  const weekStarts = useMemo(
    () => [
      { value: "", label: t("grafana-ui.week-start-picker.weekStarts-label-default", "Default") },
      { value: "saturday", label: t("grafana-ui.week-start-picker.weekStarts-label-saturday", "Saturday") },
      { value: "sunday", label: t("grafana-ui.week-start-picker.weekStarts-label-sunday", "Sunday") },
      { value: "monday", label: t("grafana-ui.week-start-picker.weekStarts-label-monday", "Monday") }
    ],
    []
  );
  const onChangeWeekStart = useCallback(
    (selectable) => {
      if (selectable && selectable.value !== void 0) {
        onChange(isWeekStart(selectable.value) ? selectable.value : void 0);
      }
    },
    [onChange]
  );
  const selected = useMemo(() => {
    var _a, _b;
    return (_b = (_a = weekStarts.find((item) => item.value === value)) == null ? void 0 : _a.value) != null ? _b : "";
  }, [value, weekStarts]);
  return /* @__PURE__ */ jsx(
    Combobox,
    {
      id: inputId,
      value: selected,
      placeholder: selectors.components.WeekStartPicker.placeholder,
      autoFocus,
      width,
      options: weekStarts,
      onChange: onChangeWeekStart,
      onBlur,
      disabled
    }
  );
};

export { WeekStartPicker, getWeekStart, isWeekStart };
//# sourceMappingURL=WeekStartPicker.mjs.map
