import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useMemo } from 'react';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';

const TimeZoneDescription = ({ info }) => {
  const styles = useStyles2(getStyles);
  const description = useDescription(info);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ jsx("div", { className: styles.description, children: description });
};
const useDescription = (info) => {
  return useMemo(() => {
    const parts = [];
    if (!info) {
      return "";
    }
    if (info.name === "Europe/Simferopol") {
      return "Ukraine, EEST";
    }
    if (info.countries.length > 0) {
      const country = info.countries[0];
      parts.push(country.name);
    }
    if (info.abbreviation) {
      parts.push(info.abbreviation);
    }
    return parts.join(", ");
  }, [info]);
};
const getStyles = (theme) => {
  return {
    description: css({
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      textOverflow: "ellipsis"
    })
  };
};

export { TimeZoneDescription };
//# sourceMappingURL=TimeZoneDescription.mjs.map
