import { jsx, Fragment } from 'react/jsx-runtime';
import { t } from '@grafana/i18n';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

function TimeSyncButton(props) {
  const { onClick, isSynced } = props;
  const syncTimesTooltip = () => {
    const tooltip = isSynced ? "Unsync all views" : "Sync all views to this time range";
    return /* @__PURE__ */ jsx(Fragment, { children: tooltip });
  };
  return /* @__PURE__ */ jsx(Tooltip, { content: syncTimesTooltip, placement: "bottom", children: /* @__PURE__ */ jsx(
    ToolbarButton,
    {
      icon: "link",
      variant: isSynced ? "active" : "canvas",
      "aria-label": isSynced ? t("grafana-ui.time-sync-button.aria-label-unsync", "Unsync times") : t("grafana-ui.time-sync-button.aria-label-sync", "Sync times"),
      onClick
    }
  ) });
}

export { TimeSyncButton };
//# sourceMappingURL=TimeSyncButton.mjs.map
