import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { memo } from 'react';
import Calendar from 'react-calendar';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { ClickOutsideWrapper } from '../../ClickOutsideWrapper/ClickOutsideWrapper.mjs';
import { Icon } from '../../Icon/Icon.mjs';
import { getBodyStyles } from '../TimeRangePicker/CalendarBody.mjs';

const DatePicker = memo((props) => {
  const styles = useStyles2(getStyles);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ jsx(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose, children: /* @__PURE__ */ jsx("div", { className: styles.modal, "data-testid": "date-picker", children: /* @__PURE__ */ jsx(Body, { ...props }) }) });
});
DatePicker.displayName = "DatePicker";
const Body = memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ jsx(
    Calendar,
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || /* @__PURE__ */ new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ jsx(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ jsx(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (ev && !Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles = (theme) => {
  return {
    modal: css({
      zIndex: theme.zIndex.modal,
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderTopLeftRadius: theme.shape.radius.default,
      borderBottomLeftRadius: theme.shape.radius.default,
      "button:disabled": {
        color: theme.colors.text.disabled
      }
    })
  };
};

export { DatePicker, getStyles };
//# sourceMappingURL=DatePicker.mjs.map
