import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { Trans } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { Icon } from '../Icon/Icon.mjs';
import { DataLinkButton } from './DataLinkButton.mjs';

function FieldLinkList({ links }) {
  const styles = useStyles2(getStyles);
  if (links.length === 1) {
    return /* @__PURE__ */ jsx(DataLinkButton, { link: links[0] });
  }
  const externalLinks = links.filter((link) => link.target === "_blank");
  const internalLinks = links.filter((link) => link.target === "_self");
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    internalLinks.map((link, i) => {
      return /* @__PURE__ */ jsx(DataLinkButton, { link }, i);
    }),
    /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
      /* @__PURE__ */ jsx("p", { className: styles.externalLinksHeading, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-ui.field-link-list.external-links-heading", children: "External links" }) }),
      externalLinks.map((link, i) => /* @__PURE__ */ jsxs("a", { href: link.href, target: link.target, className: styles.externalLink, children: [
        /* @__PURE__ */ jsx(Icon, { name: "external-link-alt" }),
        link.title
      ] }, i))
    ] })
  ] });
}
const getStyles = (theme) => ({
  wrapper: css({
    flexBasis: "150px",
    width: "100px",
    marginTop: theme.spacing(1)
  }),
  externalLinksHeading: css({
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightRegular,
    fontSize: theme.typography.size.sm,
    margin: 0
  }),
  externalLink: css({
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightRegular,
    display: "block",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    "&:hover": {
      textDecoration: "underline"
    },
    div: {
      marginRight: theme.spacing(1)
    }
  })
});

export { FieldLinkList };
//# sourceMappingURL=FieldLinkList.mjs.map
