import { jsx, jsxs } from 'react/jsx-runtime';
import { createElement } from 'react';
import { cx, css } from '@emotion/css';
import { Draggable } from '@hello-pangea/dnd';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import { Badge } from '../../Badge/Badge.mjs';
import { Icon } from '../../Icon/Icon.mjs';
import { IconButton } from '../../IconButton/IconButton.mjs';

function DataLinksListItemBase({
  item,
  onEdit,
  onRemove,
  index,
  itemKey
}) {
  var _a, _b, _c;
  const styles = useStyles2(getDataLinkListItemStyles);
  const { title = "", oneClick = false } = item;
  const url = (_c = (_b = item.url) != null ? _b : (_a = item.fetch) == null ? void 0 : _a.url) != null ? _c : "";
  const hasTitle = title.trim() !== "";
  const hasUrl = url.trim() !== "";
  return /* @__PURE__ */ jsx(Draggable, { draggableId: itemKey, index, children: (provided) => /* @__PURE__ */ createElement(
    "div",
    {
      className: cx(styles.wrapper, styles.dragRow),
      ref: provided.innerRef,
      ...provided.draggableProps,
      key: index
    },
    /* @__PURE__ */ jsxs("div", { className: styles.linkDetails, children: [
      /* @__PURE__ */ jsx("div", { className: cx(styles.url, !hasTitle && styles.notConfigured), children: hasTitle ? title : t("grafana-ui.data-links-inline-editor.title-not-provided", "Title not provided") }),
      /* @__PURE__ */ jsx("div", { className: cx(styles.url, !hasUrl && styles.notConfigured), title: url, children: hasUrl ? url : t("grafana-ui.data-links-inline-editor.url-not-provided", "Data link url not provided") })
    ] }),
    /* @__PURE__ */ jsxs("div", { className: styles.icons, children: [
      oneClick && /* @__PURE__ */ jsx(
        Badge,
        {
          color: "blue",
          text: t("grafana-ui.data-links-inline-editor.one-click", "One click"),
          tooltip: t("grafana-ui.data-links-inline-editor.one-click-enabled", "One click enabled")
        }
      ),
      /* @__PURE__ */ jsx(
        IconButton,
        {
          name: "pen",
          onClick: onEdit,
          className: styles.icon,
          tooltip: t("grafana-ui.data-links-inline-editor.tooltip-edit", "Edit")
        }
      ),
      /* @__PURE__ */ jsx(
        IconButton,
        {
          name: "trash-alt",
          onClick: onRemove,
          className: styles.icon,
          tooltip: t("grafana-ui.data-links-inline-editor.tooltip-remove", "Remove")
        }
      ),
      /* @__PURE__ */ jsx("div", { className: styles.dragIcon, ...provided.dragHandleProps, children: /* @__PURE__ */ jsx(Icon, { name: "draggabledots", size: "lg" }) })
    ] })
  ) }, itemKey);
}
const getDataLinkListItemStyles = (theme) => {
  return {
    wrapper: css({
      display: "flex",
      flexGrow: 1,
      alignItems: "center",
      justifyContent: "space-between",
      padding: "5px 0 5px 10px",
      borderRadius: theme.shape.radius.default,
      background: theme.colors.background.secondary,
      gap: 8
    }),
    linkDetails: css({
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      maxWidth: `calc(100% - 100px)`
    }),
    errored: css({
      color: theme.colors.error.text,
      fontStyle: "italic"
    }),
    notConfigured: css({
      fontStyle: "italic"
    }),
    title: css({
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    }),
    url: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    dragRow: css({
      position: "relative",
      margin: "8px"
    }),
    icons: css({
      display: "flex",
      padding: 6,
      alignItems: "center",
      gap: 8
    }),
    dragIcon: css({
      cursor: "grab",
      color: theme.colors.text.secondary,
      margin: theme.spacing(0, 0.5)
    }),
    icon: css({
      color: theme.colors.text.secondary
    })
  };
};

export { DataLinksListItemBase };
//# sourceMappingURL=DataLinksListItemBase.mjs.map
