import { jsxs, jsx, Fragment } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { forwardRef } from 'react';
import { t } from '@grafana/i18n';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { IconButton } from '../IconButton/IconButton.mjs';

const ValuePill = forwardRef(
  ({ children, onRemove, disabled, ...rest }, ref) => {
    const styles = useStyles2(getValuePillStyles, disabled);
    const removeButtonLabel = t("grafana-ui.value-pill.remove-button", "Remove {{children}}", { children });
    return /* @__PURE__ */ jsxs("span", { className: styles.wrapper, ...rest, ref, children: [
      /* @__PURE__ */ jsx("span", { className: styles.text, children }),
      !disabled && /* @__PURE__ */ jsxs(Fragment, { children: [
        /* @__PURE__ */ jsx("span", { className: styles.separator }),
        /* @__PURE__ */ jsx(
          IconButton,
          {
            name: "times",
            size: "md",
            "aria-label": removeButtonLabel,
            onClick: (e) => {
              e.stopPropagation();
              onRemove();
            }
          }
        )
      ] })
    ] });
  }
);
const getValuePillStyles = (theme, disabled) => ({
  wrapper: css({
    display: "inline-flex",
    borderRadius: theme.shape.radius.default,
    color: theme.colors.text.primary,
    background: theme.colors.background.secondary,
    padding: theme.spacing(0.25),
    border: disabled ? `1px solid ${theme.colors.border.weak}` : "none",
    fontSize: theme.typography.bodySmall.fontSize,
    flexShrink: 0,
    minWidth: "50px",
    alignItems: "center",
    "&:first-child:has(+ div)": {
      flexShrink: 1
    }
  }),
  text: css({
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0, 1, 0, 0.75)
  }),
  separator: css({
    background: theme.colors.border.weak,
    width: "2px",
    height: "100%",
    marginRight: theme.spacing(0.5)
  })
});

export { ValuePill };
//# sourceMappingURL=ValuePill.mjs.map
