import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import { forwardRef } from 'react';
import { useStyles2 } from '../../themes/ThemeContext.mjs';

const ButtonGroup = forwardRef(({ className, children, ...rest }, ref) => {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx("div", { ref, className: cx("button-group", styles.wrapper, className), ...rest, children });
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles = (theme) => ({
  wrapper: css({
    display: "flex",
    borderRadius: theme.shape.radius.default,
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: "unset",
      borderBottomLeftRadius: "unset",
      borderLeft: `1px solid rgba(255, 255, 255, 0.12)`
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: "unset",
      borderBottomRightRadius: "unset",
      borderRight: `1px solid rgba(0, 0, 0, 0.12)`
    }
  })
});

export { ButtonGroup };
//# sourceMappingURL=ButtonGroup.mjs.map
