import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { t } from '@grafana/i18n';
import { useTheme2 } from '../../themes/ThemeContext.mjs';
import { Button } from '../Button/Button.mjs';
import { ConfirmModal } from '../ConfirmModal/ConfirmModal.mjs';
import { VariablesInputModal } from './VariablesInputModal.mjs';

function ActionButton({ action, ...buttonProps }) {
  const theme = useTheme2();
  const backgroundColor = action.style.backgroundColor || theme.colors.secondary.main;
  const textColor = theme.colors.getContrastText(backgroundColor);
  const [showConfirm, setShowConfirm] = useState(false);
  const [showVarsModal, setShowVarsModal] = useState(false);
  const [actionVars, setActionVars] = useState({});
  const actionHasVariables = action.variables && action.variables.length > 0;
  const onClick = () => {
    if (actionHasVariables) {
      setShowVarsModal(true);
    } else {
      setShowConfirm(true);
    }
  };
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsx(
      Button,
      {
        variant: "primary",
        size: "sm",
        onClick,
        ...buttonProps,
        style: { width: "fit-content", backgroundColor, color: textColor },
        children: action.title
      }
    ),
    actionHasVariables && showVarsModal && /* @__PURE__ */ jsx(
      VariablesInputModal,
      {
        onDismiss: () => setShowVarsModal(false),
        action,
        onShowConfirm: () => setShowConfirm(true),
        variables: actionVars,
        setVariables: setActionVars
      }
    ),
    showConfirm && /* @__PURE__ */ jsx(
      ConfirmModal,
      {
        isOpen: true,
        title: t("grafana-ui.action-editor.button.confirm-action", "Confirm action"),
        body: action.confirmation(actionVars),
        confirmText: t("grafana-ui.action-editor.button.confirm", "Confirm"),
        confirmButtonVariant: "primary",
        onConfirm: () => {
          setShowConfirm(false);
          action.onClick(new MouseEvent("click"), null, actionVars);
        },
        onDismiss: () => {
          setShowConfirm(false);
        }
      }
    )
  ] });
}

export { ActionButton };
//# sourceMappingURL=ActionButton.mjs.map
