import { GrafanaTheme2 } from '../themes/types';
import { Field, FieldConfig, NumericRange } from '../types/dataFrame';
import { Threshold } from '../types/thresholds';
export interface ColorScaleValue {
    percent: number;
    threshold: Threshold | undefined;
    color: string;
}
export type ScaleCalculator = (value: number) => ColorScaleValue;
export declare function getScaleCalculator(field: Field, theme: GrafanaTheme2): ScaleCalculator;
export declare function getMinMaxAndDelta(field: Field): NumericRange;
/**
 * @internal
 */
export declare function getFieldConfigWithMinMax(field: Field, local?: boolean): FieldConfig;
