import { isString } from 'lodash';

function getDataSourceRef(ds) {
  const ref = { uid: ds.uid, type: ds.type };
  if (ds.apiVersion) {
    ref.apiVersion = ds.apiVersion;
  }
  return ref;
}
function isDataSourceRef(ref) {
  return typeof ref === "object" && typeof (ref == null ? void 0 : ref.uid) === "string";
}
function getDataSourceUID(ref) {
  if (isDataSourceRef(ref)) {
    return ref.uid;
  }
  if (isString(ref)) {
    return ref;
  }
  return void 0;
}
const onUpdateDatasourceOption = (props, key) => (event) => {
  updateDatasourcePluginOption(props, key, event.currentTarget.value);
};
const onUpdateDatasourceJsonDataOption = (props, key) => (event) => {
  updateDatasourcePluginJsonDataOption(props, key, event.currentTarget.value);
};
const onUpdateDatasourceSecureJsonDataOption = (props, key) => (event) => {
  updateDatasourcePluginSecureJsonDataOption(props, key, event.currentTarget.value);
};
const onUpdateDatasourceJsonDataOptionSelect = (props, key) => (selected) => {
  updateDatasourcePluginJsonDataOption(props, key, selected.value);
};
const onUpdateDatasourceJsonDataOptionChecked = (props, key) => (event) => {
  updateDatasourcePluginJsonDataOption(props, key, event.currentTarget.checked);
};
const onUpdateDatasourceSecureJsonDataOptionSelect = (props, key) => (selected) => {
  updateDatasourcePluginSecureJsonDataOption(props, key, selected.value);
};
const onUpdateDatasourceResetOption = (props, key) => (event) => {
  updateDatasourcePluginResetOption(props, key);
};
function updateDatasourcePluginOption(props, key, val) {
  const config = props.options;
  props.onOptionsChange({
    ...config,
    [key]: val
  });
}
const updateDatasourcePluginJsonDataOption = (props, key, val) => {
  const config = props.options;
  props.onOptionsChange({
    ...config,
    jsonData: {
      ...config.jsonData,
      [key]: val
    }
  });
};
const updateDatasourcePluginSecureJsonDataOption = (props, key, val) => {
  const config = props.options;
  props.onOptionsChange({
    ...config,
    secureJsonData: {
      ...config.secureJsonData ? config.secureJsonData : {},
      [key]: val
    }
  });
};
const updateDatasourcePluginResetOption = (props, key) => {
  const config = props.options;
  props.onOptionsChange({
    ...config,
    secureJsonData: {
      ...config.secureJsonData ? config.secureJsonData : {},
      [key]: ""
    },
    secureJsonFields: {
      ...config.secureJsonFields,
      [key]: false
    }
  });
};

export { getDataSourceRef, getDataSourceUID, isDataSourceRef, onUpdateDatasourceJsonDataOption, onUpdateDatasourceJsonDataOptionChecked, onUpdateDatasourceJsonDataOptionSelect, onUpdateDatasourceOption, onUpdateDatasourceResetOption, onUpdateDatasourceSecureJsonDataOption, onUpdateDatasourceSecureJsonDataOptionSelect, updateDatasourcePluginJsonDataOption, updateDatasourcePluginOption, updateDatasourcePluginResetOption, updateDatasourcePluginSecureJsonDataOption };
//# sourceMappingURL=datasource.mjs.map
