import { stringStartsAsRegEx, stringToJsRegex, escapeStringForRegex } from '../../text/string.mjs';
import { FrameMatcherID } from './ids.mjs';

const refIdMatcher = {
  id: FrameMatcherID.byRefId,
  name: "Query refId",
  description: "match the refId",
  defaultOptions: "A",
  get: (pattern) => {
    let regex = null;
    if (stringStartsAsRegEx(pattern)) {
      try {
        regex = stringToJsRegex(pattern);
      } catch (error) {
        if (error instanceof Error) {
          console.warn(error.message);
        }
      }
    } else if (pattern.includes("|")) {
      const escapedUnion = pattern.split("|").map(escapeStringForRegex).join("|");
      regex = new RegExp(`^(?:${escapedUnion})$`);
    }
    return (frame) => {
      var _a;
      return (_a = regex == null ? void 0 : regex.test(frame.refId || "")) != null ? _a : frame.refId === pattern;
    };
  },
  getOptionsDisplayText: (pattern) => {
    return `RefID: ${pattern}`;
  }
};
function getRefIdMatchers() {
  return [refIdMatcher];
}

export { getRefIdMatchers };
//# sourceMappingURL=refIdMatcher.mjs.map
