import { Registry } from '@grafana/data';
import { renderLabels } from './rendering/labels.mjs';
import { renderOperations, hasBinaryOp } from './rendering/operations.mjs';
import { renderBinaryQueries, renderQuery } from './rendering/query.mjs';

class LokiAndPromQueryModellerBase {
  constructor(getOperations) {
    this.categories = [];
    this.operationsMapCache = null;
    this.operationsRegistry = new Registry(getOperations);
  }
  getOperationsMap() {
    if (!this.operationsMapCache) {
      this.operationsMapCache = /* @__PURE__ */ new Map();
      this.operationsRegistry.list().forEach((op) => {
        this.operationsMapCache.set(op.id, op);
      });
    }
    return this.operationsMapCache;
  }
  setOperationCategories(categories) {
    this.categories = categories;
  }
  getOperationsForCategory(category) {
    return this.operationsRegistry.list().filter((op) => op.category === category && !op.hideFromList);
  }
  getAlternativeOperations(key) {
    return this.operationsRegistry.list().filter((op) => op.alternativesKey && op.alternativesKey === key);
  }
  getCategories() {
    return this.categories;
  }
  getOperationDef(id) {
    return this.operationsRegistry.getIfExists(id);
  }
  renderOperations(queryString, operations) {
    return renderOperations(queryString, operations, this.getOperationsMap());
  }
  renderBinaryQueries(queryString, binaryQueries) {
    return renderBinaryQueries(queryString, binaryQueries);
  }
  renderLabels(labels) {
    return renderLabels(labels);
  }
  renderQuery(query, nested) {
    return renderQuery(query, nested, this.getOperationsMap());
  }
  hasBinaryOp(query) {
    return hasBinaryOp(query, this.getOperationsMap());
  }
}

export { LokiAndPromQueryModellerBase };
//# sourceMappingURL=LokiAndPromQueryModellerBase.mjs.map
