import { jsx, jsxs } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { t, Trans } from '@grafana/i18n';
import { useStyles2, Stack, Icon } from '@grafana/ui';

function FeedbackLink({ feedbackUrl }) {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(Stack, { children: /* @__PURE__ */ jsxs(
    "a",
    {
      href: feedbackUrl,
      className: styles.link,
      title: t(
        "grafana-prometheus.querybuilder.feedback-link.title-give-feedback",
        "The metrics explorer is new, please let us know how we can improve it"
      ),
      target: "_blank",
      rel: "noreferrer noopener",
      children: [
        /* @__PURE__ */ jsx(Icon, { name: "comment-alt-message" }),
        " ",
        /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.feedback-link.give-feedback", children: "Give feedback" })
      ]
    }
  ) });
}
function getStyles(theme) {
  return {
    link: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      ":hover": {
        color: theme.colors.text.link
      },
      margin: `-25px 0 30px 0`
    })
  };
}

export { FeedbackLink };
//# sourceMappingURL=FeedbackLink.mjs.map
