import { jsx, jsxs } from 'react/jsx-runtime';
import { useState, useCallback, useEffect } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { Trans, t } from '@grafana/i18n';
import { config } from '@grafana/runtime';
import { Stack, Text, IconButton } from '@grafana/ui';
import { isSuggestionsIncompleteEvent, CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT } from '../../components/monaco-query-field/monaco-completion-provider/data_provider.mjs';
import { QueryEditorMode } from '../shared/types.mjs';

function PromQueryCodeEditorAutocompleteInfo(props) {
  const [autocompleteLimit, setAutocompleteLimit] = useState("n");
  const [autocompleteLimitExceeded, setAutocompleteLimitExceeded] = useState(false);
  const handleSuggestionsIncompleteEvent = useCallback(
    (e) => {
      if (!isSuggestionsIncompleteEvent(e)) {
        return;
      }
      if (e.detail.datasourceUid === props.datasourceUid) {
        setAutocompleteLimitExceeded(true);
        setAutocompleteLimit(e.detail.limit.toString());
      }
    },
    [props.datasourceUid]
  );
  useEffect(() => {
    window.addEventListener(CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT, handleSuggestionsIncompleteEvent);
    return () => {
      window.removeEventListener(CODE_MODE_SUGGESTIONS_INCOMPLETE_EVENT, handleSuggestionsIncompleteEvent);
    };
  }, [handleSuggestionsIncompleteEvent]);
  const showCodeModeAutocompleteDisclaimer = () => {
    return Boolean(config.featureToggles.prometheusCodeModeMetricNamesSearch) && props.editorMode === QueryEditorMode.Code && autocompleteLimitExceeded;
  };
  if (!showCodeModeAutocompleteDisclaimer()) {
    return null;
  }
  return /* @__PURE__ */ jsx("div", { "data-testid": selectors.components.DataSource.Prometheus.queryEditor.code.metricsCountInfo, children: /* @__PURE__ */ jsxs(Stack, { direction: "row", gap: 1, children: [
    /* @__PURE__ */ jsx(Text, { color: "secondary", element: "p", italic: true, children: /* @__PURE__ */ jsx(Trans, { i18nKey: "grafana-prometheus.querybuilder.prom-query-code-editor-autocomplete-info.autocomplete-suggestions-limited", children: "Autocomplete suggestions limited" }) }),
    /* @__PURE__ */ jsx(
      IconButton,
      {
        name: "info-circle",
        tooltip: t(
          "grafana-prometheus.querybuilder.prom-query-code-editor-autocomplete-info.tooltip-autocomplete-suggestions-limited",
          "The number of metric names exceeds the autocomplete limit. Only the {{autocompleteLimit}}-most relevant metrics are displayed. You can adjust the threshold in the data source settings.",
          { autocompleteLimit }
        )
      }
    )
  ] }) });
}

export { PromQueryCodeEditorAutocompleteInfo };
//# sourceMappingURL=PromQueryCodeEditorAutocompleteInfo.mjs.map
