import { jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { toOption } from '@grafana/data';
import { t } from '@grafana/i18n';
import { Select } from '@grafana/ui';
import { getOperationParamId } from '../shared/param_utils.mjs';

function LabelParamEditor({
  onChange,
  index,
  operationId,
  value,
  query,
  datasource,
  timeRange,
  queryModeller
}) {
  const [state, setState] = useState({});
  return /* @__PURE__ */ jsx(
    Select,
    {
      inputId: getOperationParamId(operationId, index),
      autoFocus: value === "" ? true : void 0,
      openMenuOnFocus: true,
      onOpenMenu: async () => {
        setState({ isLoading: true });
        const options = await loadGroupByLabels(timeRange, query, datasource, queryModeller);
        setState({ options, isLoading: void 0 });
      },
      isLoading: state.isLoading,
      allowCustomValue: true,
      noOptionsMessage: t(
        "grafana-prometheus.querybuilder.label-param-editor.noOptionsMessage-no-labels-found",
        "No labels found"
      ),
      loadingMessage: t(
        "grafana-prometheus.querybuilder.label-param-editor.loadingMessage-loading-labels",
        "Loading labels"
      ),
      options: state.options,
      value: toOption(value),
      onChange: (value2) => onChange(index, value2.value)
    }
  );
}
async function loadGroupByLabels(timeRange, query, datasource, modeller) {
  let labels = query.labels;
  if (datasource.type === "prometheus") {
    labels = [{ label: "__name__", op: "=", value: query.metric }, ...query.labels];
  }
  const expr = modeller.renderLabels(labels);
  const result = await datasource.languageProvider.queryLabelKeys(timeRange, expr);
  return result.map((x) => ({
    label: x,
    value: x
  }));
}

export { LabelParamEditor };
//# sourceMappingURL=LabelParamEditor.mjs.map
