import { config } from '@grafana/runtime';

function prometheusRegularEscape(value) {
  if (typeof value !== "string") {
    return value;
  }
  if (config.featureToggles.prometheusSpecialCharsInLabelValues) {
    if (/^\w+(=|!=|=~|!~)".*"$/.test(value)) {
      return value;
    }
    return value.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
  }
  return value.replace(/\\/g, "\\\\").replace(/'/g, "\\\\'");
}
function prometheusSpecialRegexEscape(value) {
  if (typeof value !== "string") {
    return value;
  }
  if (config.featureToggles.prometheusSpecialCharsInLabelValues) {
    return value.replace(/\\/g, "\\\\\\\\").replace(/"/g, '\\\\\\"').replace(/[$^*{}\[\]\'+?.()|]/g, "\\\\$&");
  }
  return value.replace(/\\/g, "\\\\\\\\").replace(/[$^*{}\[\]+?.()|]/g, "\\\\$&");
}
const RE2_METACHARACTERS = /[*+?()|\\.\[\]{}^$]/g;
function escapePrometheusRegexp(value) {
  return value.replace(RE2_METACHARACTERS, "\\$&");
}
function escapeLabelValueInExactSelector(labelValue) {
  return labelValue.replace(/\\/g, "\\\\").replace(/\n/g, "\\n").replace(/"/g, '\\"');
}
function escapeLabelValueInRegexSelector(labelValue) {
  return escapeLabelValueInExactSelector(escapePrometheusRegexp(labelValue));
}

export { escapeLabelValueInExactSelector, escapeLabelValueInRegexSelector, prometheusRegularEscape, prometheusSpecialRegexEscape };
//# sourceMappingURL=escaping.mjs.map
