import { escapeLabelValueInRegexSelector, escapeLabelValueInExactSelector } from '../../escaping.mjs';
import { utf8Support, isValidLegacyName } from '../../utf8_support.mjs';

function buildSelector(selectedMetric, selectedLabelValues) {
  if (selectedMetric === "" && Object.keys(selectedLabelValues).length === 0) {
    return "{}";
  }
  const selectorParts = [];
  for (const [key, values] of Object.entries(selectedLabelValues)) {
    if (values.length === 0) {
      continue;
    }
    if (values.length > 1) {
      selectorParts.push(`${utf8Support(key)}=~"${values.map(escapeLabelValueInRegexSelector).join("|")}"`);
    } else {
      selectorParts.push(`${utf8Support(key)}="${escapeLabelValueInExactSelector(values[0])}"`);
    }
  }
  if (selectedMetric === "") {
    return `{${selectorParts.join(",")}}`;
  }
  if (isValidLegacyName(selectedMetric)) {
    return `${selectedMetric}{${selectorParts.join(",")}}`;
  }
  selectorParts.unshift(utf8Support(selectedMetric));
  return `{${selectorParts.join(",")}}`;
}

export { buildSelector };
//# sourceMappingURL=selectorBuilder.mjs.map
