import { TFunction as I18NextTFunction } from 'i18next';
import { ResourceLoader, Resources, TFunction, TransProps } from './types';
export declare function loadNamespacedResources(namespace: string, language: string, loaders?: ResourceLoader[]): Promise<void[] | undefined>;
export declare function initDefaultI18nInstance(): Promise<I18NextTFunction<"translation", undefined>> | undefined;
export declare function initDefaultReactI18nInstance(): void;
export declare function initPluginTranslations(id: string, loaders?: ResourceLoader[]): Promise<{
    language: string;
}>;
export declare function getI18nInstance(): import("i18next").i18n;
interface Module {
    type: 'backend';
}
interface InitializeI18nOptions {
    ns?: string[];
    language?: string;
    module?: Module;
}
export declare function getLanguage(): string;
export declare function getResolvedLanguage(): string;
export declare function getNamespaces(): string | readonly string[] | undefined;
export declare function changeLanguage(language?: string): Promise<void>;
export declare function initializeI18n({ language, ns, module }: InitializeI18nOptions, regionalFormat: string): Promise<{
    language: string | undefined;
}>;
export declare function addResourceBundle(language: string, namespace: string, resources: Resources): void;
export declare const t: TFunction;
export declare function Trans(props: TransProps): import("react/jsx-runtime").JSX.Element;
export {};
