import { jsx } from 'react/jsx-runtime';
import i18n from 'i18next';
import 'i18next-browser-languagedetector';
import { initReactI18next, getI18n, setDefaults, setI18n, Trans as Trans$1 } from 'react-i18next';
import { PSEUDO_LOCALE, DEFAULT_LANGUAGE } from './constants.mjs';
import './dates.mjs';
import { LANGUAGES } from './languages.mjs';

let tFunc;
let transComponent;
[
  ...LANGUAGES,
  {
    name: "Pseudo",
    code: PSEUDO_LOCALE
  }
];
function initTFuncAndTransComponent({ id, ns } = {}) {
  if (id) {
    tFunc = getI18nInstance().getFixedT(null, id);
    transComponent = (props) => /* @__PURE__ */ jsx(Trans$1, { shouldUnescape: true, ns: id, ...props });
    return;
  }
  tFunc = getI18nInstance().t;
  transComponent = (props) => /* @__PURE__ */ jsx(Trans$1, { shouldUnescape: true, ns, ...props });
}
async function loadNamespacedResources(namespace, language, loaders) {
  if (!(loaders == null ? void 0 : loaders.length)) {
    return;
  }
  const resolvedLanguage = language === PSEUDO_LOCALE ? DEFAULT_LANGUAGE : language;
  return Promise.all(
    loaders.map(async (loader) => {
      try {
        const resources = await loader(resolvedLanguage);
        addResourceBundle(resolvedLanguage, namespace, resources);
      } catch (error) {
        console.error(`Error loading resources for namespace ${namespace} and language: ${resolvedLanguage}`, error);
      }
    })
  );
}
function initDefaultI18nInstance() {
  var _a;
  if (((_a = getI18nInstance().options) == null ? void 0 : _a.resources) && typeof getI18nInstance().options.resources === "object") {
    return;
  }
  const initPromise = getI18nInstance().use(initReactI18next).init({
    resources: {},
    returnEmptyString: false,
    lng: DEFAULT_LANGUAGE
    // this should be the locale of the phrases in our source JSX
  });
  initTFuncAndTransComponent();
  return initPromise;
}
function initDefaultReactI18nInstance() {
  var _a, _b;
  if ((_b = (_a = getI18n()) == null ? void 0 : _a.options) == null ? void 0 : _b.react) {
    return;
  }
  const options = {};
  setDefaults(options);
  setI18n(getI18nInstance());
}
async function initPluginTranslations(id, loaders) {
  await initDefaultI18nInstance();
  initDefaultReactI18nInstance();
  const language = getResolvedLanguage();
  initTFuncAndTransComponent({ id });
  await loadNamespacedResources(id, language, loaders);
  return { language };
}
function getI18nInstance() {
  return i18n;
}
function getResolvedLanguage() {
  var _a;
  return ((_a = getI18nInstance()) == null ? void 0 : _a.resolvedLanguage) || DEFAULT_LANGUAGE;
}
function addResourceBundle(language, namespace, resources) {
  getI18nInstance().addResourceBundle(language, namespace, resources, true, false);
}
const t = (id, defaultMessage, values) => {
  initDefaultI18nInstance();
  if (!tFunc) {
    if (process.env.NODE_ENV !== "test") {
      console.warn(
        "t() was called before i18n was initialized. This is probably caused by calling t() in the root module scope, instead of lazily on render"
      );
    }
    if (process.env.NODE_ENV === "development") {
      throw new Error("t() was called before i18n was initialized");
    }
    tFunc = getI18nInstance().t;
  }
  return tFunc(id, defaultMessage, values);
};
function Trans(props) {
  initDefaultI18nInstance();
  const Component = transComponent != null ? transComponent : Trans$1;
  return /* @__PURE__ */ jsx(Component, { shouldUnescape: true, ...props });
}

export { Trans, addResourceBundle, getI18nInstance, getResolvedLanguage, initDefaultI18nInstance, initDefaultReactI18nInstance, initPluginTranslations, loadNamespacedResources, t };
//# sourceMappingURL=i18n.mjs.map
