import { config } from '../config.mjs';
import { getEchoSrv, EchoEventType } from '../services/EchoSrv.mjs';
import '@grafana/data';
import { locationService } from '../services/LocationService.mjs';
import '../services/appEvents.mjs';
import 'react/jsx-runtime';
import 'react';
import '../services/ScopesContext.mjs';

const reportMetaAnalytics = (payload) => {
  getEchoSrv().addEvent({
    type: EchoEventType.MetaAnalytics,
    payload
  });
};
const reportPageview = () => {
  var _a;
  const location = locationService.getLocation();
  const page = `${(_a = config.appSubUrl) != null ? _a : ""}${location.pathname}${location.search}${location.hash}`;
  getEchoSrv().addEvent({
    type: EchoEventType.Pageview,
    payload: {
      page
    }
  });
};
const reportInteraction = (interactionName, properties) => {
  if (config.reportingStaticContext && config.reportingStaticContext instanceof Object) {
    properties = { ...properties, ...config.reportingStaticContext };
  }
  getEchoSrv().addEvent({
    type: EchoEventType.Interaction,
    payload: {
      interactionName,
      properties
    }
  });
};
const reportExperimentView = (id, group, variant) => {
  getEchoSrv().addEvent({
    type: EchoEventType.ExperimentView,
    payload: {
      experimentId: id,
      experimentGroup: group,
      experimentVariant: variant
    }
  });
};

export { reportExperimentView, reportInteraction, reportMetaAnalytics, reportPageview };
//# sourceMappingURL=utils.mjs.map
