import { PluginExtensionFunction } from '@grafana/data';
export type UsePluginFunctionsOptions = {
    extensionPointId: string;
    limitPerPlugin?: number;
};
export type UsePluginFunctionsResult<Signature> = {
    isLoading: boolean;
    functions: Array<PluginExtensionFunction<Signature>>;
};
export type UsePluginFunctions<T> = (options: UsePluginFunctionsOptions) => UsePluginFunctionsResult<T>;
export declare function setPluginFunctionsHook(hook: UsePluginFunctions<unknown>): void;
export declare function usePluginFunctions<T>(options: UsePluginFunctionsOptions): UsePluginFunctionsResult<T>;
