import { TimeOption, TimeRange, TimeZone } from '@grafana/data';
import { WeekStart } from './WeekStartPicker';
/** @public */
export interface TimeRangePickerProps {
    hideText?: boolean;
    value: TimeRange;
    timeZone?: TimeZone;
    fiscalYearStartMonth?: number;
    /**
     * If you handle sync state between pickers yourself use this prop to pass the sync button component.
     * Otherwise, a default one will show automatically if sync is possible.
     */
    timeSyncButton?: JSX.Element;
    isSynced?: boolean;
    initialIsSynced?: boolean;
    onChange: (timeRange: TimeRange) => void;
    onChangeTimeZone: (timeZone: TimeZone) => void;
    onChangeFiscalYearStartMonth?: (month: number) => void;
    onMoveBackward: () => void;
    onMoveForward: () => void;
    onZoom: () => void;
    onError?: (error?: string) => void;
    history?: TimeRange[];
    quickRanges?: TimeOption[];
    hideQuickRanges?: boolean;
    widthOverride?: number;
    isOnCanvas?: boolean;
    onToolbarTimePickerClick?: () => void;
    /** Which day of the week the calendar should start on. Possible values: "saturday", "sunday" or "monday" */
    weekStart?: WeekStart;
}
export interface State {
    isOpen: boolean;
}
export declare function TimeRangePicker(props: TimeRangePickerProps): import("react/jsx-runtime").JSX.Element;
export declare namespace TimeRangePicker {
    var displayName: string;
}
export declare const TimePickerTooltip: ({ timeRange, timeZone }: {
    timeRange: TimeRange;
    timeZone?: TimeZone;
}) => import("react/jsx-runtime").JSX.Element;
type LabelProps = Pick<TimeRangePickerProps, 'hideText' | 'value' | 'timeZone' | 'quickRanges'>;
export declare const TimePickerButtonLabel: import("react").NamedExoticComponent<LabelProps>;
export {};
