import { jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { selectors } from '@grafana/e2e-selectors';
import { useStyles2 } from '../../themes/ThemeContext.mjs';
import { ToolbarButton } from '../ToolbarButton/ToolbarButton.mjs';

function PanelStatus({ message, onClick, ariaLabel = "status" }) {
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsx(
    ToolbarButton,
    {
      className: styles.buttonStyles,
      onClick,
      variant: "destructive",
      icon: "exclamation-triangle",
      iconSize: "md",
      tooltip: message || "",
      "aria-label": ariaLabel,
      "data-testid": selectors.components.Panels.Panel.status("error")
    }
  );
}
const getStyles = (theme) => {
  const { headerHeight, padding } = theme.components.panel;
  return {
    buttonStyles: css({
      label: "panel-header-state-button",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      padding: theme.spacing(padding),
      width: theme.spacing(headerHeight),
      height: theme.spacing(headerHeight),
      borderRadius: theme.shape.radius.default
    })
  };
};

export { PanelStatus };
//# sourceMappingURL=PanelStatus.mjs.map
