import { jsx } from 'react/jsx-runtime';
import { memo, useCallback } from 'react';
import { FieldMatcherID, fieldMatchers } from '@grafana/data';
import { t } from '@grafana/i18n';
import { Select } from '../Select/Select.mjs';
import { useFieldDisplayNames, useSelectOptions, frameHasName } from './utils.mjs';

const FieldNameMatcherEditor = memo((props) => {
  const { data, options, onChange: onChangeFromProps, id } = props;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions(names, options);
  const onChange = useCallback(
    (selection) => {
      if (!frameHasName(selection.value, names)) {
        return;
      }
      return onChangeFromProps(selection.value);
    },
    [names, onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ jsx(Select, { value: selectedOption, options: selectOptions, onChange, inputId: id });
});
FieldNameMatcherEditor.displayName = "FieldNameMatcherEditor";
const getFieldNameMatcherItem = () => ({
  id: FieldMatcherID.byName,
  component: FieldNameMatcherEditor,
  matcher: fieldMatchers.get(FieldMatcherID.byName),
  name: t("grafana-ui.matchers-ui.name-fields-with-name", "Fields with name"),
  description: t("grafana-ui.matchers-ui.description-fields-with-name", "Set properties for a specific field"),
  optionsToLabel: (options) => options
});

export { FieldNameMatcherEditor, getFieldNameMatcherItem };
//# sourceMappingURL=FieldNameMatcherEditor.mjs.map
