import { jsxs, jsx } from 'react/jsx-runtime';
import classNames from 'classnames';
import { Icon } from '../Icon/Icon.mjs';
import { Tooltip } from '../Tooltip/Tooltip.mjs';

const FormLabel = ({
  children,
  isFocused,
  isInvalid,
  className,
  htmlFor,
  tooltip,
  width,
  interactive,
  ...rest
}) => {
  const classes = classNames(className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ jsxs("label", { className: classes, ...rest, htmlFor, children: [
    children,
    tooltip && /* @__PURE__ */ jsx(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive, children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }) })
  ] });
};
const InlineFormLabel = FormLabel;

export { FormLabel, InlineFormLabel };
//# sourceMappingURL=FormLabel.mjs.map
