import { QueryHint } from '@grafana/data';
import { PrometheusDatasource } from './datasource';
import { QueryBuilderLabelFilter } from './querybuilder/shared/types';
import { PromVisualQuery } from './querybuilder/types';
import { RecordingRuleIdentifier, RuleQueryMapping } from './types';
/**
 * Number of time series results needed before starting to suggest sum aggregation hints
 */
export declare const SUM_HINT_THRESHOLD_COUNT = 20;
export declare function getQueryHints(query: string, series?: unknown[], datasource?: PrometheusDatasource): QueryHint[];
export declare function getInitHints(datasource: PrometheusDatasource): QueryHint[];
export declare function isRuleInQuery(query: string, ruleName: string): boolean;
export declare function getExpandRulesHints(query: string, mapping: RuleQueryMapping): QueryHint[];
export declare function getRecordingRuleIdentifierIdx(queryStr: string, ruleName: string, mapping: RuleQueryMapping[string]): RecordingRuleIdentifier & {
    idx: number;
};
export declare function getQueryLabelsForRuleName(metricName: string, query: PromVisualQuery): QueryBuilderLabelFilter[];
