import { PrometheusCacheLevel } from './types.mjs';

const getDebounceTimeInMilliseconds = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 600;
    case PrometheusCacheLevel.High:
      return 1200;
    default:
      return 350;
  }
};
const getDaysToCacheMetadata = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 7;
    case PrometheusCacheLevel.High:
      return 30;
    default:
      return 1;
  }
};
const getCacheDurationInMinutes = (cacheLevel) => {
  switch (cacheLevel) {
    case PrometheusCacheLevel.Medium:
      return 10;
    case PrometheusCacheLevel.High:
      return 60;
    default:
      return 1;
  }
};
const buildCacheHeaders = (durationInSeconds) => {
  return {
    headers: {
      "X-Grafana-Cache": `private, max-age=${durationInSeconds}`
    }
  };
};
const getDefaultCacheHeaders = (cacheLevel) => {
  if (cacheLevel !== PrometheusCacheLevel.None) {
    return buildCacheHeaders(getCacheDurationInMinutes(cacheLevel) * 60);
  }
  return;
};

export { buildCacheHeaders, getCacheDurationInMinutes, getDaysToCacheMetadata, getDebounceTimeInMilliseconds, getDefaultCacheHeaders };
//# sourceMappingURL=caching.mjs.map
